/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.data.json.JsonUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class JsonDeserializers {
    public static <T> Optional<T> readPrimitiveValue(JsonElement element, Function<JsonElement, T> deserializer) {
        try {
            if (element.isJsonPrimitive()) {
                return Optional.ofNullable(deserializer.apply(element));
            }
            MaLiLib.LOGGER.warn("Failed to deserialize value from the JSON element '{}' - not a JSON primitive", (Object)element);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Exception while trying to deserialize a primitive value from the JSON element '{}'", (Object)element, (Object)e);
        }
        return Optional.empty();
    }

    public static Optional<Path> readPath(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                return Optional.ofNullable(Paths.get(element.getAsString(), new String[0]));
            }
            MaLiLib.LOGGER.warn("Failed to deserialize a path from the JSON element '{}' - not a JSON primitive", (Object)element);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Exception while trying to deserialize a path from the JSON element '{}'", (Object)element, (Object)e);
        }
        return Optional.empty();
    }

    public static Optional<Pair<Color4f, Color4f>> readDualColorValue(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (JsonUtils.hasInteger(obj, "color1") && JsonUtils.hasInteger(obj, "color2")) {
                    int value1 = JsonUtils.getInteger(obj, "color1");
                    int value2 = JsonUtils.getInteger(obj, "color2");
                    return Optional.of(Pair.of((Object)Color4f.fromColor(value1), (Object)Color4f.fromColor(value2)));
                }
            } else {
                MaLiLib.LOGGER.warn("Failed to read DualColorConfig value from the JSON element '{}'", (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to read DualColorConfig value from the JSON element '{}'", (Object)element, (Object)e);
        }
        return Optional.empty();
    }
}

