/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.value.FileWriteType;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.data.BooleanConsumer;
import fi.dy.masa.malilib.util.data.FloatConsumer;
import fi.dy.masa.malilib.util.position.BlockMirror;
import fi.dy.masa.malilib.util.position.BlockRotation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class JsonUtils {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void copyPropertyIfExists(JsonObject srcObj, JsonObject dstObj, String name) {
        if (srcObj.has(name)) {
            dstObj.add(name, JsonUtils.deepCopy(srcObj.get(name)));
        }
    }

    @Nullable
    public static JsonObject getNestedObject(JsonObject parent, String key, boolean create) {
        if (!parent.has(key) || !parent.get(key).isJsonObject()) {
            if (!create) {
                return null;
            }
            JsonObject obj = new JsonObject();
            parent.add(key, (JsonElement)obj);
            return obj;
        }
        return parent.get(key).getAsJsonObject();
    }

    public static boolean hasBoolean(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsBoolean();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasInteger(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsInt();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasLong(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsLong();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasFloat(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsFloat();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasDouble(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsDouble();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasString(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsString();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasObject(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        return el != null && el.isJsonObject();
    }

    public static boolean hasArray(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        return el != null && el.isJsonArray();
    }

    public static boolean getBooleanOrDefault(JsonObject obj, String name, boolean defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getIntegerOrDefault(JsonObject obj, String name, int defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLongOrDefault(JsonObject obj, String name, long defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsLong();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloatOrDefault(JsonObject obj, String name, float defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsFloat();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double getDoubleOrDefault(JsonObject obj, String name, double defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsDouble();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Nullable
    public static String getStringOrDefault(JsonObject obj, String name, @Nullable String defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void getBooleanIfExists(JsonObject obj, String name, BooleanConsumer consumer) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                consumer.accept(obj.get(name).getAsBoolean());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getIntegerIfExists(JsonObject obj, String name, IntConsumer consumer) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                consumer.accept(obj.get(name).getAsInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getLongIfExists(JsonObject obj, String name, LongConsumer consumer) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                consumer.accept(obj.get(name).getAsLong());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getFloatIfExists(JsonObject obj, String name, FloatConsumer consumer) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                consumer.accept(obj.get(name).getAsFloat());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getDoubleIfExists(JsonObject obj, String name, DoubleConsumer consumer) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                consumer.accept(obj.get(name).getAsDouble());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getStringIfExists(JsonObject obj, String name, Consumer<String> consumer) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                consumer.accept(obj.get(name).getAsString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean getBoolean(JsonObject obj, String name) {
        return JsonUtils.getBooleanOrDefault(obj, name, false);
    }

    public static int getInteger(JsonObject obj, String name) {
        return JsonUtils.getIntegerOrDefault(obj, name, 0);
    }

    public static long getLong(JsonObject obj, String name) {
        return JsonUtils.getLongOrDefault(obj, name, 0L);
    }

    public static float getFloat(JsonObject obj, String name) {
        return JsonUtils.getFloatOrDefault(obj, name, 0.0f);
    }

    public static double getDouble(JsonObject obj, String name) {
        return JsonUtils.getDoubleOrDefault(obj, name, 0.0);
    }

    @Nullable
    public static String getString(JsonObject obj, String name) {
        return JsonUtils.getStringOrDefault(obj, name, null);
    }

    public static void addIfNotEqual(JsonObject obj, String name, int value, int excludeValue) {
        if (value != excludeValue) {
            obj.addProperty(name, (Number)value);
        }
    }

    public static void addIfNotEqual(JsonObject obj, String name, float value, float excludeValue) {
        if (value != excludeValue) {
            obj.addProperty(name, (Number)Float.valueOf(value));
        }
    }

    public static void addIfNotEqual(JsonObject obj, String name, double value, double excludeValue) {
        if (value != excludeValue) {
            obj.addProperty(name, (Number)value);
        }
    }

    public static void addIfNotEqual(JsonObject obj, String name, boolean value, boolean excludeValue) {
        if (value != excludeValue) {
            obj.addProperty(name, Boolean.valueOf(value));
        }
    }

    public static void addIfNotEqual(JsonObject obj, String name, String value, String excludeValue) {
        if (!value.equals(excludeValue)) {
            obj.addProperty(name, value);
        }
    }

    public static void addIfNotEqual(JsonObject obj, String name, BlockRotation value, BlockRotation excludeValue) {
        if (value != excludeValue) {
            obj.addProperty(name, value.getName());
        }
    }

    public static void addIfNotEqual(JsonObject obj, String name, BlockMirror value, BlockMirror excludeValue) {
        if (value != excludeValue) {
            obj.addProperty(name, value.getName());
        }
    }

    public static void addStringIfNotNull(JsonObject obj, String name, @Nullable String value) {
        if (value != null) {
            obj.addProperty(name, value);
        }
    }

    public static void addElementIfNotNull(JsonObject obj, String name, @Nullable JsonElement el) {
        if (el != null) {
            obj.add(name, el);
        }
    }

    public static boolean hasBlockPos(JsonObject obj, String name) {
        return JsonUtils.getBlockPos(obj, name) != null;
    }

    public static JsonArray blockPosToJson(class_2382 pos) {
        JsonArray arr = new JsonArray();
        arr.add((JsonElement)new JsonPrimitive((Number)pos.method_10263()));
        arr.add((JsonElement)new JsonPrimitive((Number)pos.method_10264()));
        arr.add((JsonElement)new JsonPrimitive((Number)pos.method_10260()));
        return arr;
    }

    @Nullable
    public static class_2382 getVec3i(JsonObject obj, String name) {
        JsonArray arr;
        if (JsonUtils.hasArray(obj, name) && (arr = obj.getAsJsonArray(name)).size() == 3) {
            try {
                return new class_2382(arr.get(0).getAsInt(), arr.get(1).getAsInt(), arr.get(2).getAsInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static class_2382 getVec3iOrDefault(JsonObject obj, String name, @Nullable class_2382 defaultVec) {
        class_2382 vec = JsonUtils.getVec3i(obj, name);
        return vec != null ? vec : defaultVec;
    }

    public static void getVec3iIfExists(JsonObject obj, String name, Consumer<class_2382> consumer) {
        class_2382 vec = JsonUtils.getVec3i(obj, name);
        if (vec != null) {
            consumer.accept(vec);
        }
    }

    @Nullable
    public static class_2338 getBlockPos(JsonObject obj, String name) {
        JsonArray arr;
        if (JsonUtils.hasArray(obj, name) && (arr = obj.getAsJsonArray(name)).size() == 3) {
            try {
                return new class_2338(arr.get(0).getAsInt(), arr.get(1).getAsInt(), arr.get(2).getAsInt());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static class_2338 getBlockPosOrDefault(JsonObject obj, String name, @Nullable class_2338 defaultPos) {
        class_2338 pos = JsonUtils.getBlockPos(obj, name);
        return pos != null ? pos : defaultPos;
    }

    public static void getBlockPosIfExists(JsonObject obj, String name, Consumer<class_2338> consumer) {
        class_2338 pos = JsonUtils.getBlockPos(obj, name);
        if (pos != null) {
            consumer.accept(pos);
        }
    }

    public static void putBlockPosIfNotNull(JsonObject obj, String name, @Nullable class_2338 pos) {
        if (pos != null) {
            obj.add(name, (JsonElement)JsonUtils.blockPosToJson((class_2382)pos));
        }
    }

    public static boolean hasVec3d(JsonObject obj, String name) {
        return JsonUtils.getVec3d(obj, name) != null;
    }

    public static JsonArray vec3dToJson(class_243 vec) {
        JsonArray arr = new JsonArray();
        arr.add((JsonElement)new JsonPrimitive((Number)vec.field_1352));
        arr.add((JsonElement)new JsonPrimitive((Number)vec.field_1351));
        arr.add((JsonElement)new JsonPrimitive((Number)vec.field_1350));
        return arr;
    }

    @Nullable
    public static class_243 getVec3d(JsonObject obj, String name) {
        JsonArray arr;
        if (JsonUtils.hasArray(obj, name) && (arr = obj.getAsJsonArray(name)).size() == 3) {
            try {
                return new class_243(arr.get(0).getAsDouble(), arr.get(1).getAsDouble(), arr.get(2).getAsDouble());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static class_243 getVec3dOrDefault(JsonObject obj, String name, @Nullable class_243 defaultVec) {
        class_243 vec = JsonUtils.getVec3d(obj, name);
        return vec != null ? vec : defaultVec;
    }

    public static void getVec3dIfExists(JsonObject obj, String name, Consumer<class_243> consumer) {
        class_243 vec = JsonUtils.getVec3d(obj, name);
        if (vec != null) {
            consumer.accept(vec);
        }
    }

    public static BlockRotation getRotation(JsonObject obj, String name) {
        String str = JsonUtils.getString(obj, name);
        if (str != null) {
            try {
                return BlockRotation.byName(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BlockRotation.NONE;
    }

    public static BlockMirror getMirror(JsonObject obj, String name) {
        String str = JsonUtils.getString(obj, name);
        if (str != null) {
            try {
                return BlockMirror.byName(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BlockMirror.NONE;
    }

    public static JsonArray stringListAsArray(List<String> list) {
        JsonArray arr = new JsonArray();
        for (String str : list) {
            arr.add((JsonElement)new JsonPrimitive(str));
        }
        return arr;
    }

    public static List<String> arrayAsStringList(JsonArray arr) {
        ArrayList<String> list = new ArrayList<String>();
        int count = arr.size();
        for (int i = 0; i < count; ++i) {
            list.add(arr.get(i).getAsString());
        }
        return list;
    }

    public static void getObjectIfExists(JsonElement el, String objectName, Consumer<JsonObject> objectConsumer) {
        if (!el.isJsonObject()) {
            return;
        }
        JsonObject parentObj = el.getAsJsonObject();
        if (JsonUtils.hasObject(parentObj, objectName)) {
            JsonObject obj = parentObj.get(objectName).getAsJsonObject();
            objectConsumer.accept(obj);
        }
    }

    public static void getArrayIfExists(JsonElement el, String arrayName, Consumer<JsonArray> arrayConsumer) {
        if (!el.isJsonObject()) {
            return;
        }
        JsonObject obj = el.getAsJsonObject();
        if (JsonUtils.hasArray(obj, arrayName)) {
            JsonArray arr = obj.get(arrayName).getAsJsonArray();
            arrayConsumer.accept(arr);
        }
    }

    public static void getArrayElementsIfExists(JsonElement el, String arrayName, Consumer<JsonElement> elementConsumer) {
        JsonUtils.getArrayIfExists(el, arrayName, arr -> JsonUtils.getArrayElements(arr, elementConsumer));
    }

    public static void getArrayElements(JsonArray arr, Consumer<JsonElement> elementConsumer) {
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            elementConsumer.accept(arr.get(i));
        }
    }

    public static void getArrayElementsIfObjects(JsonElement el, String arrayName, Consumer<JsonObject> elementConsumer) {
        JsonUtils.getArrayIfExists(el, arrayName, arr -> JsonUtils.getArrayElementsAsObjects(arr, elementConsumer));
    }

    public static void getArrayElementsAsObjects(JsonArray arr, Consumer<JsonObject> elementConsumer) {
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            JsonElement el = arr.get(i);
            if (!el.isJsonObject()) continue;
            elementConsumer.accept(el.getAsJsonObject());
        }
    }

    public static <T> JsonArray toArray(Collection<T> values, Function<T, JsonElement> elementSerializer) {
        JsonArray arr = new JsonArray();
        for (T value : values) {
            JsonElement el = elementSerializer.apply(value);
            if (el == null) continue;
            arr.add(el);
        }
        return arr;
    }

    @Nonnull
    public static JsonObject deepCopy(@Nonnull JsonObject jsonObject) {
        JsonObject result = new JsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            result.add((String)entry.getKey(), JsonUtils.deepCopy((JsonElement)entry.getValue()));
        }
        return result;
    }

    @Nonnull
    public static JsonArray deepCopy(@Nonnull JsonArray jsonArray) {
        JsonArray result = new JsonArray();
        for (JsonElement e : jsonArray) {
            result.add(JsonUtils.deepCopy(e));
        }
        return result;
    }

    @Nonnull
    public static JsonElement deepCopy(@Nonnull JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive() || jsonElement.isJsonNull()) {
            return jsonElement;
        }
        if (jsonElement.isJsonObject()) {
            return JsonUtils.deepCopy(jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonArray()) {
            return JsonUtils.deepCopy(jsonElement.getAsJsonArray());
        }
        throw new UnsupportedOperationException("Unsupported element: " + String.valueOf(jsonElement));
    }

    @Nullable
    public static JsonElement parseJsonFromString(String str) {
        try {
            return JsonParser.parseString((String)str);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static JsonElement parseJsonFile(Path file) {
        if (Files.isRegularFile(file, new LinkOption[0]) && Files.isReadable(file)) {
            JsonElement jsonElement;
            block9: {
                BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);
                try {
                    jsonElement = JsonParser.parseReader((Reader)reader);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        MaLiLib.LOGGER.error("Failed to parse the JSON file '{}'", (Object)file.toAbsolutePath(), (Object)e);
                    }
                }
                reader.close();
            }
            return jsonElement;
        }
        return null;
    }

    public static String jsonToString(JsonElement element, boolean compact) {
        Gson gson = compact ? new Gson() : GSON;
        return gson.toJson(element);
    }

    public static boolean writeJsonToFile(JsonObject root, File file) {
        boolean bl;
        File fileTmp = new File(file.getParentFile(), file.getName() + ".tmp");
        if (fileTmp.exists()) {
            fileTmp = new File(file.getParentFile(), String.valueOf(UUID.randomUUID()) + ".tmp");
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileTmp), StandardCharsets.UTF_8);
        try {
            writer.write(GSON.toJson((JsonElement)root));
            writer.close();
            if (file.exists() && file.isFile() && !file.delete()) {
                MaLiLib.LOGGER.warn("Failed to delete file '{}'", (Object)file.getAbsolutePath());
            }
            bl = fileTmp.renameTo(file);
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                MaLiLib.LOGGER.warn("Failed to write JSON data to file '{}'", (Object)fileTmp.getAbsolutePath(), (Object)e);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public static boolean writeJsonToFile(JsonElement root, Path file) {
        return JsonUtils.writeJsonToFile(root, file, GSON);
    }

    public static boolean writeJsonToFile(JsonElement root, Path file, Gson gson) {
        return FileUtils.writeDataToFile(file, w -> JsonUtils.writeJsonToWriter(root, file, w, gson), FileWriteType.NORMAL_WRITE);
    }

    public static void writeJsonToWriter(JsonElement root, Path file, BufferedWriter writer, Gson gson) {
        try {
            writer.write(gson.toJson(root));
        }
        catch (IOException e) {
            MaLiLib.LOGGER.warn("Failed to write JSON data to file '{}'", (Object)file.toAbsolutePath(), (Object)e);
        }
    }

    public static void loadFromFile(Path dir, String fileName, Consumer<JsonElement> dataConsumer) {
        Path file = dir.resolve(fileName);
        JsonUtils.loadFromFile(file, dataConsumer);
    }

    public static void loadFromFile(Path file, Consumer<JsonElement> dataConsumer) {
        JsonElement element = JsonUtils.parseJsonFile(file);
        if (element != null) {
            dataConsumer.accept(element);
        }
    }
}

