/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4482;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8242;
import net.minecraft.class_8514;
import net.minecraft.class_9296;
import org.apache.commons.lang3.tuple.Pair;

public class NbtBlockUtils {
    @Nullable
    public static class_2591<?> getBlockEntityTypeFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("id", 8)) {
            return class_7923.field_41181.method_17966(class_2960.method_12829((String)nbt.method_10558("id"))).orElse(null);
        }
        return null;
    }

    public static class_2487 setBlockEntityTypeToNbt(class_2591<?> type, @Nullable class_2487 nbtIn) {
        class_2487 nbt = new class_2487();
        class_2960 id = class_2591.method_11033(type);
        if (id != null) {
            if (nbtIn != null) {
                nbtIn.method_10582("id", id.toString());
                return nbtIn;
            }
            nbt.method_10582("id", id.toString());
        }
        return nbt;
    }

    public static Set<Integer> getDisabledSlotsFromNbt(@Nonnull class_2487 nbt) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (nbt.method_10573("disabled_slots", 11)) {
            int[] is;
            for (int j : is = nbt.method_10561("disabled_slots")) {
                list.add(j);
            }
        }
        return list;
    }

    public static Pair<class_6880<class_1291>, class_6880<class_1291>> getBeaconEffectsFromNbt(@Nonnull class_2487 nbt) {
        class_2960 id;
        class_6880 primary = null;
        class_6880 secondary = null;
        if (nbt.method_10573("primary_effect", 8) && (id = class_2960.method_12829((String)nbt.method_10558("primary_effect"))) != null) {
            primary = class_7923.field_41174.method_10223(id).orElse(null);
        }
        if (nbt.method_10573("secondary_effect", 8) && (id = class_2960.method_12829((String)nbt.method_10558("secondary_effect"))) != null) {
            secondary = class_7923.field_41174.method_10223(id).orElse(null);
        }
        return Pair.of(primary, secondary);
    }

    public static Pair<List<class_4482.class_9309>, class_2338> getBeesDataFromNbt(@Nonnull class_2487 nbt) {
        ArrayList bees = new ArrayList();
        class_2338 flower = class_2338.field_10980;
        if (nbt.method_10545("bees")) {
            class_4482.class_9309.field_49412.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("bees")).resultOrPartial().ifPresent(bees::addAll);
        }
        if (nbt.method_10573("flower_pos", 11)) {
            flower = NbtUtils.readBlockPosFromIntArray(nbt, "flower_pos");
        }
        return Pair.of(bees, (Object)flower);
    }

    public static Pair<Integer, class_8514.class_8515> getSkulkSensorVibrationsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        AtomicReference<Object> data = new AtomicReference<Object>(null);
        int lastFreq = -1;
        if (nbt.method_10573("last_vibration_frequency", 3)) {
            lastFreq = nbt.method_10550("last_vibration_frequency");
        }
        if (nbt.method_10573("listener", 10)) {
            class_8514.class_8515.field_44640.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10562("listener")).resultOrPartial().ifPresent(data::set);
        }
        return Pair.of((Object)lastFreq, (Object)data.get());
    }

    public static Pair<Long, class_2338> getExitPortalFromNbt(@Nonnull class_2487 nbt) {
        long age = -1L;
        class_2338 pos = class_2338.field_10980;
        if (nbt.method_10573("Age", 4)) {
            age = nbt.method_10537("Age");
        }
        if (nbt.method_10573("exit_portal", 11)) {
            pos = NbtUtils.readBlockPosFromIntArray(nbt, "exit_portal");
        }
        return Pair.of((Object)age, (Object)pos);
    }

    public static Pair<Pair<class_8242, class_8242>, Boolean> getSignTextFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        AtomicReference<Object> front = new AtomicReference<Object>(null);
        AtomicReference<Object> back = new AtomicReference<Object>(null);
        boolean waxed = false;
        if (nbt.method_10545("front_text")) {
            class_8242.field_43298.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10562("front_text")).resultOrPartial().ifPresent(front::set);
        }
        if (nbt.method_10545("back_text")) {
            class_8242.field_43298.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10562("back_text")).resultOrPartial().ifPresent(back::set);
        }
        if (nbt.method_10545("is_waxed")) {
            waxed = nbt.method_10577("is_waxed");
        }
        return Pair.of((Object)Pair.of((Object)front.get(), (Object)back.get()), (Object)waxed);
    }

    public static Pair<class_1799, Integer> getBookFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_1799 book = class_1799.field_8037;
        int current = -1;
        if (nbt.method_10573("Book", 10)) {
            book = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("Book"));
        }
        if (nbt.method_10573("Page", 3)) {
            current = nbt.method_10550("Page");
        }
        return Pair.of((Object)book, (Object)current);
    }

    public static Pair<class_9296, Pair<class_2960, class_2561>> getSkullDataFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        AtomicReference<Object> profile = new AtomicReference<Object>(null);
        class_2960 note = null;
        class_5250 name = class_2561.method_43473();
        if (nbt.method_10573("note_block_sound", 8)) {
            note = class_2960.method_12829((String)nbt.method_10558("note_block_sound"));
        }
        if (nbt.method_10573("custom_name", 8)) {
            String str = nbt.method_10558("custom_name");
            try {
                name = class_2561.class_2562.method_10877((String)str, (class_7225.class_7874)registry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nbt.method_10545("profile")) {
            class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("profile")).resultOrPartial().ifPresent(profile::set);
        }
        return Pair.of((Object)profile.get(), (Object)Pair.of((Object)note, (Object)name));
    }

    public static Reference2IntOpenHashMap<class_5321<class_1860<?>>> getRecipesUsedFromNbt(@Nonnull class_2487 nbt) {
        Reference2IntOpenHashMap list = new Reference2IntOpenHashMap();
        if (nbt.method_10573("RecipesUsed", 10)) {
            class_2487 compound = nbt.method_10562("RecipesUsed");
            for (String key : compound.method_10541()) {
                list.put((Object)class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)class_2960.method_60654((String)key)), compound.method_10550(key));
            }
        }
        return list;
    }

    public static int getOutputSignalFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("OutputSignal", 3)) {
            return nbt.method_10550("OutputSignal");
        }
        return 0;
    }
}

