/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.util.EntityUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1440;
import net.minecraft.class_1453;
import net.minecraft.class_1463;
import net.minecraft.class_1474;
import net.minecraft.class_1501;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_156;
import net.minecraft.class_1702;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1916;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3441;
import net.minecraft.class_3850;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5135;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5762;
import net.minecraft.class_6880;
import net.minecraft.class_7106;
import net.minecraft.class_7225;
import net.minecraft.class_7375;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9346;
import net.minecraft.class_9347;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class NbtEntityUtils {
    @Nullable
    public static class_1299<?> getEntityTypeFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("id", 8)) {
            return class_7923.field_41177.method_17966(class_2960.method_12829((String)nbt.method_10558("id"))).orElse(null);
        }
        return null;
    }

    public class_2487 setEntityTypeToNbt(class_1299<?> type, @Nullable class_2487 nbtIn) {
        class_2487 nbt = new class_2487();
        class_2960 id = class_1299.method_5890(type);
        if (id != null) {
            if (nbtIn != null) {
                nbtIn.method_10582("id", id.toString());
                return nbtIn;
            }
            nbt.method_10582("id", id.toString());
        }
        return nbt;
    }

    @Nullable
    public static class_5131 getAttributesFromNbt(@Nonnull class_2487 nbt) {
        class_1299<?> type = NbtEntityUtils.getEntityTypeFromNbt(nbt);
        if (type != null && nbt.method_10573("attributes", 9)) {
            class_5131 container = new class_5131(class_5135.method_26873(type));
            container.method_26850(nbt.method_10554("attributes", 10));
            return container;
        }
        return null;
    }

    public static double getAttributeBaseValueFromNbt(@Nonnull class_2487 nbt, class_6880<class_1320> attribute) {
        class_5131 attributes = NbtEntityUtils.getAttributesFromNbt(nbt);
        if (attributes != null) {
            return attributes.method_26856(attribute);
        }
        return -1.0;
    }

    public static double getAttributeValueFromNbt(@Nonnull class_2487 nbt, class_6880<class_1320> attribute) {
        class_5131 attributes = NbtEntityUtils.getAttributesFromNbt(nbt);
        if (attributes != null) {
            return attributes.method_26852(attribute);
        }
        return -1.0;
    }

    public static Pair<Double, Double> getHealthFromNbt(@Nonnull class_2487 nbt) {
        double maxHealth;
        double health = 0.0;
        if (nbt.method_10573("Health", 99)) {
            health = nbt.method_10583("Health");
        }
        if ((maxHealth = NbtEntityUtils.getAttributeValueFromNbt(nbt, (class_6880<class_1320>)class_5134.field_23716)) < 0.0) {
            maxHealth = 20.0;
        }
        return Pair.of((Object)health, (Object)maxHealth);
    }

    public static Pair<Double, Double> getSpeedAndJumpStrengthFromNbt(@Nonnull class_2487 nbt) {
        class_5131 container = NbtEntityUtils.getAttributesFromNbt(nbt);
        double moveSpeed = 0.0;
        double jumpStrength = 0.0;
        if (container != null) {
            moveSpeed = container.method_26852(class_5134.field_23719);
            jumpStrength = container.method_26852(class_5134.field_23728);
        }
        return Pair.of((Object)moveSpeed, (Object)jumpStrength);
    }

    @Nullable
    public static UUID getUUIDFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_25928("UUID")) {
            return nbt.method_25926("UUID");
        }
        return null;
    }

    @Nullable
    public static class_2561 getCustomNameFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10573("CustomName", 8)) {
            String string = nbt.method_10558("CustomName");
            try {
                return class_2561.class_2562.method_10877((String)string, (class_7225.class_7874)registry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static class_2487 setCustomNameToNbt(@Nonnull class_2561 name, @Nonnull class_5455 registry, @Nullable class_2487 nbtIn) {
        class_2487 nbt = new class_2487();
        try {
            if (nbtIn != null) {
                nbtIn.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)name, (class_7225.class_7874)registry));
                return nbtIn;
            }
            nbt.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)name, (class_7225.class_7874)registry));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nbt;
    }

    public static Map<class_6880<class_1291>, class_1293> getActiveStatusEffectsFromNbt(@Nonnull class_2487 nbt) {
        HashMap statusEffects = Maps.newHashMap();
        if (nbt.method_10573("active_effects", 9)) {
            class_2499 list = nbt.method_10554("active_effects", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 data = list.method_10602(i);
                class_1293 instance = class_1293.method_5583((class_2487)data);
                if (instance == null) continue;
                statusEffects.put(instance.method_5579(), instance);
            }
        }
        return statusEffects;
    }

    public static class_2371<class_1799> getHandItemsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_2371 list = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        if (nbt.method_10573("HandItems", 9)) {
            class_2499 nbtList = nbt.method_10554("HandItems", 10);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbtList.method_10602(i)));
            }
        }
        return list;
    }

    public static class_2371<class_1799> getArmorItemsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_2371 list = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        if (nbt.method_10573("ArmorItems", 9)) {
            class_2499 nbtList = nbt.method_10554("ArmorItems", 10);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbtList.method_10602(i)));
            }
        }
        return list;
    }

    public static class_1799 getBodyArmorFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10573("body_armor_item", 10)) {
            return class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("body_armor_item"));
        }
        return class_1799.field_8037;
    }

    public static Pair<UUID, class_1799> getOwnerAndSaddle(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        UUID owner = class_156.field_25140;
        class_1799 saddle = class_1799.field_8037;
        if (nbt.method_25928("Owner")) {
            owner = nbt.method_25926("Owner");
        }
        if (nbt.method_10573("SaddleItem", 10)) {
            saddle = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("SaddleItem"));
        }
        return Pair.of((Object)owner, (Object)saddle);
    }

    public static Pair<Integer, Integer> getAgeFromNbt(@Nonnull class_2487 nbt) {
        int breedingAge = 0;
        int forcedAge = 0;
        if (nbt.method_10545("Age")) {
            breedingAge = nbt.method_10550("Age");
        }
        if (nbt.method_10545("ForcedAge")) {
            forcedAge = nbt.method_10550("ForcedAge");
        }
        return Pair.of((Object)breedingAge, (Object)forcedAge);
    }

    @Nullable
    public static class_1916 getTradeOffersFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        Optional opt;
        if (nbt.method_10545("Offers") && (opt = class_1916.field_48850.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("Offers")).resultOrPartial()).isPresent()) {
            return (class_1916)opt.get();
        }
        return null;
    }

    @Nullable
    public static class_3850 getVillagerDataFromNbt(@Nonnull class_2487 nbt) {
        Optional opt;
        if (nbt.method_10573("VillagerData", 10) && (opt = class_3850.field_24669.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("VillagerData"))).resultOrPartial()).isPresent()) {
            return (class_3850)opt.get();
        }
        return null;
    }

    public static Pair<Integer, UUID> getZombieConversionTimerFromNbt(@Nonnull class_2487 nbt) {
        int timer = -1;
        UUID player = class_156.field_25140;
        if (nbt.method_10573("ConversionTime", 99)) {
            timer = nbt.method_10550("ConversionTime");
        }
        if (nbt.method_25928("ConversionPlayer")) {
            player = nbt.method_25926("ConversionPlayer");
        }
        return Pair.of((Object)timer, (Object)player);
    }

    public static Pair<Integer, Integer> getDrownedConversionTimerFromNbt(@Nonnull class_2487 nbt) {
        int drowning = -1;
        int inWater = -1;
        if (nbt.method_10573("DrownedConversionTime", 99)) {
            drowning = nbt.method_10550("DrownedConversionTime");
        }
        if (nbt.method_10573("InWaterTime", 3)) {
            inWater = nbt.method_10550("InWaterTime");
        }
        return Pair.of((Object)drowning, (Object)inWater);
    }

    public static int getStrayConversionTimeFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("StrayConversionTime", 99)) {
            return nbt.method_10550("StrayConversionTime");
        }
        return -1;
    }

    public static class_6880.class_6883<class_1299<?>> getEntityTypeEntry(class_2960 id, @Nonnull class_5455 registry) {
        try {
            return (class_6880.class_6883)registry.method_30530(class_7923.field_41177.method_46765()).method_10223(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static EntityUtils.FakeLeashData getLeashDataFromNbt(@Nonnull class_2487 nbt) {
        Either either;
        EntityUtils.FakeLeashData data = null;
        if (nbt.method_10573("leash", 10)) {
            data = new EntityUtils.FakeLeashData(-1, null, (Either<UUID, class_2338>)Either.left((Object)nbt.method_10562("leash").method_25926("UUID")));
        } else if (nbt.method_10573("leash", 11) && (either = (Either)class_2512.method_10691((class_2487)nbt, (String)"leash").map(Either::right).orElse(null)) != null) {
            return new EntityUtils.FakeLeashData(-1, null, (Either<UUID, class_2338>)either);
        }
        return data;
    }

    public static Pair<class_1440.class_1443, class_1440.class_1443> getPandaGenesFromNbt(@Nonnull class_2487 nbt) {
        class_1440.class_1443 mainGene = null;
        class_1440.class_1443 hiddenGene = null;
        if (nbt.method_10573("MainGene", 8)) {
            mainGene = class_1440.class_1443.method_6567((String)nbt.method_10558("MainGene"));
        }
        if (nbt.method_10573("HiddenGene", 8)) {
            hiddenGene = class_1440.class_1443.method_6567((String)nbt.method_10558("HiddenGene"));
        }
        return Pair.of((Object)mainGene, hiddenGene);
    }

    public static Pair<class_2350, class_2350> getItemFrameDirectionsFromNbt(@Nonnull class_2487 nbt) {
        class_2350 facing = null;
        class_2350 rotation = null;
        if (nbt.method_10573("Facing", 1)) {
            facing = class_2350.method_10143((int)nbt.method_10571("Facing"));
        }
        if (nbt.method_10573("ItemRotation", 1)) {
            rotation = class_2350.method_10143((int)nbt.method_10571("ItemRotation"));
        }
        return Pair.of((Object)facing, rotation);
    }

    public static Pair<class_2350, class_1535> getPaintingDataFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_2350 facing = null;
        class_6880 variant = null;
        if (nbt.method_10573("facing", 1)) {
            facing = class_2350.method_10139((int)nbt.method_10571("facing"));
        }
        if (nbt.method_10573("variant", 10)) {
            variant = class_1534.field_49239.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).resultOrPartial().orElse(null);
        }
        return Pair.of((Object)facing, variant != null ? (class_1535)variant.comp_349() : null);
    }

    @Nullable
    public static class_5762.class_5767 getAxolotlVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("Variant", 3)) {
            return class_5762.class_5767.method_47928((int)nbt.method_10550("Variant"));
        }
        return null;
    }

    public static Pair<class_5321<class_7375>, class_1767> getCatVariantFromNbt(@Nonnull class_2487 nbt) {
        class_5321 variantKey = null;
        class_1767 collar = null;
        if (nbt.method_10573("variant", 8) && (variantKey = class_5321.method_29179((class_5321)class_7924.field_41259, (class_2960)class_2960.method_12829((String)nbt.method_10558("variant")))) == null) {
            variantKey = class_7375.field_38719;
        }
        if (nbt.method_10573("CollarColor", 99)) {
            collar = class_1767.method_7791((int)nbt.method_10550("CollarColor"));
        }
        return Pair.of((Object)variantKey, collar);
    }

    @Nullable
    public static class_5321<class_7106> getFrogVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("variant", 8)) {
            class_5321 variantKey = class_5321.method_29179((class_5321)class_7924.field_41272, (class_2960)class_2960.method_12829((String)nbt.method_10558("variant")));
            if (variantKey == null) {
                variantKey = class_7106.field_37462;
            }
            return variantKey;
        }
        return null;
    }

    public static Pair<class_5149, class_5148> getHorseVariantFromNbt(@Nonnull class_2487 nbt) {
        class_5149 color = null;
        class_5148 marking = null;
        if (nbt.method_10573("Variant", 3)) {
            int variant = nbt.method_10550("Variant");
            color = class_5149.method_27083((int)(variant & 0xFF));
            marking = class_5148.method_27080((int)((variant & 0xFF00) >> 8));
        }
        return Pair.of(color, marking);
    }

    @Nullable
    public static class_1453.class_7989 getParrotVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("Variant", 3)) {
            return class_1453.class_7989.method_47850((int)nbt.method_10550("Variant"));
        }
        return null;
    }

    @Nullable
    public static class_1474.class_1475 getFishVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("Variant", 3)) {
            return class_1474.class_1475.method_47868((int)(nbt.method_10550("Variant") & 0xFFFF));
        }
        if (nbt.method_10573("BucketVariantTag", 3)) {
            return class_1474.class_1475.method_47868((int)(nbt.method_10550("BucketVariantTag") & 0xFFFF));
        }
        return null;
    }

    public static Pair<class_5321<class_9346>, class_1767> getWolfVariantFromNbt(@Nonnull class_2487 nbt) {
        class_5321 variantKey = null;
        class_1767 collar = null;
        if (nbt.method_10573("variant", 8) && (variantKey = class_5321.method_29179((class_5321)class_7924.field_49772, (class_2960)class_2960.method_12829((String)nbt.method_10558("variant")))) == null) {
            variantKey = class_9347.field_49725;
        }
        if (nbt.method_10573("CollarColor", 99)) {
            collar = class_1767.method_7791((int)nbt.method_10550("CollarColor"));
        }
        return Pair.of((Object)variantKey, collar);
    }

    @Nullable
    public static class_1767 getSheepColorFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("Color", 1)) {
            return class_1767.method_7791((int)nbt.method_10571("Color"));
        }
        return null;
    }

    @Nullable
    public static class_1463.class_7990 getRabbitTypeFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("RabbitType", 3)) {
            return class_1463.class_7990.method_47857((int)nbt.method_10550("RabbitType"));
        }
        return null;
    }

    public static Pair<class_1501.class_7993, Integer> getLlamaTypeFromNbt(@Nonnull class_2487 nbt) {
        class_1501.class_7993 variant = null;
        int strength = -1;
        if (nbt.method_10573("Variant", 3)) {
            variant = class_1501.class_7993.method_47876((int)nbt.method_10550("Variant"));
        }
        if (nbt.method_10573("Strength", 3)) {
            strength = nbt.method_10550("Strength");
        }
        return Pair.of((Object)variant, (Object)strength);
    }

    public static Triple<Integer, Integer, Float> getPlayerExpFromNbt(@Nonnull class_2487 nbt) {
        int level = -1;
        int total = -1;
        float progress = 0.0f;
        if (nbt.method_10573("XpLevel", 3)) {
            level = nbt.method_10550("XpLevel");
        }
        if (nbt.method_10573("XpTotal", 3)) {
            total = nbt.method_10550("XpTotal");
        }
        if (nbt.method_10573("XpP", 5)) {
            progress = nbt.method_10583("XpP");
        }
        return Triple.of((Object)level, (Object)total, (Object)Float.valueOf(progress));
    }

    @Nullable
    public static class_1702 getPlayerHungerFromNbt(@Nonnull class_2487 nbt) {
        class_1702 hunger = null;
        if (nbt.method_10573("foodLevel", 99)) {
            hunger = new class_1702();
            hunger.method_7584(nbt);
        }
        return hunger;
    }

    @Nullable
    public static class_3441 getPlayerRecipeBookFromNbt(@Nonnull class_2487 nbt, @Nonnull class_1863 manager) {
        class_3441 book = null;
        if (nbt.method_10573("recipeBook", 10)) {
            book = new class_3441((arg_0, arg_1) -> ((class_1863)manager).method_64679(arg_0, arg_1));
            book.method_14901(nbt.method_10562("recipeBook"), key -> manager.method_8130(key).isPresent());
        }
        return book;
    }
}

