/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.copperhopper;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.pcal.copperhopper.CohoScreenHandler;
import net.pcal.copperhopper.CopperHopperBlockEntity;
import net.pcal.copperhopper.CopperHopperMinecartEntity;
import net.pcal.copperhopper.CopperInventory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class CopperHopperMod {
    public static final String LOGGER_NAME = "CopperHopper";
    public static final String LOG_PREFIX = "[CopperHopper] ";
    public static final class_2960 COHO_BLOCK_ID = class_2960.method_60654((String)"copperhopper:copper_hopper");
    public static final class_2960 COHO_ITEM_ID = class_2960.method_60654((String)"copperhopper:copper_hopper");
    public static final class_2960 COHO_SCREEN_ID = class_2960.method_60654((String)"copperhopper:copper_hopper");
    public static final class_2960 COHO_BLOCK_ENTITY_TYPE_ID = class_2960.method_60654((String)"copperhopper:copper_hopper_entity");
    public static final class_2960 COHO_MINECART_ITEM_ID = class_2960.method_60654((String)"copperhopper:copper_hopper_minecart");
    public static final class_2960 COHO_MINECART_ENTITY_TYPE_ID = class_2960.method_60654((String)"copperhopper:copper_hopper_minecart");
    private static final String CONFIG_FILENAME = "copperhopper.properties";
    private static final String DEFAULT_CONFIG_FILENAME = "default-copperhopper.properties";
    private final Logger logger = LogManager.getLogger((String)"CopperHopper");
    private final Path configFilePath = Paths.get("config", "copperhopper.properties");
    private final File configFile = this.configFilePath.toFile();
    private Collection<class_2960> nbtMatchEnabledIds = Collections.emptySet();

    public static CopperHopperMod mod() {
        return SingletonHolder.INSTANCE;
    }

    public class_2248 getBlock() {
        return (class_2248)class_7923.field_41175.method_63535(COHO_BLOCK_ID);
    }

    public class_1792 getMinecartItem() {
        return (class_1792)class_7923.field_41178.method_63535(COHO_MINECART_ITEM_ID);
    }

    public class_2591<CopperHopperBlockEntity> getBlockEntityType() {
        return Objects.requireNonNull((class_2591)class_7923.field_41181.method_63535(COHO_BLOCK_ENTITY_TYPE_ID));
    }

    public class_1299<CopperHopperMinecartEntity> getMinecartEntityType() {
        return Objects.requireNonNull((class_1299)class_7923.field_41177.method_63535(COHO_MINECART_ENTITY_TYPE_ID));
    }

    public class_3917<CohoScreenHandler> getScreenHandlerType() {
        return Objects.requireNonNull((class_3917)class_7923.field_41187.method_63535(COHO_SCREEN_ID));
    }

    public Properties loadConfig() throws IOException {
        String configuredLevel;
        Properties config;
        this.setLogLevel(Level.INFO);
        try (FileInputStream in = new FileInputStream(this.configFile);){
            Properties newProps = new Properties();
            newProps.load(in);
            config = newProps;
        }
        String nbtMatchEnabledIds = config.getProperty("nbtMatchEnabledIds");
        if (nbtMatchEnabledIds != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String id : nbtMatchEnabledIds.trim().split("\\s+")) {
                class_2960 r = class_2960.method_60654((String)id);
                this.logger.debug(() -> "nbtMatchEnabled for " + String.valueOf(r));
                builder.add((Object)r);
            }
            this.nbtMatchEnabledIds = builder.build();
        }
        if ((configuredLevel = config.getProperty("log-level")) != null) {
            Level logLevel = Level.getLevel((String)configuredLevel);
            if (logLevel == null) {
                this.logger.warn("[CopperHopper] Invalid logLevel " + configuredLevel + " in " + this.configFile.getAbsolutePath());
            } else {
                this.setLogLevel(logLevel);
                this.logger.info("[CopperHopper] LogLevel set to " + String.valueOf(logLevel));
            }
        }
        this.logger.info("[CopperHopper] Configuration loaded: " + String.valueOf(config));
        return config;
    }

    public void createDefaultConfig() throws IOException {
        if (!this.configFile.exists()) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILENAME);){
                if (in == null) {
                    throw new IllegalStateException("Unable to load default-copperhopper.properties");
                }
                this.configFilePath.getParent().toFile().mkdirs();
                Files.copy(in, this.configFilePath, new CopyOption[0]);
                this.logger.info("[CopperHopper] Wrote default copperhopper.properties");
            }
        }
    }

    public String getPolymerName() {
        return "Item Filter";
    }

    public boolean shouldVetoPushInto(CopperInventory into, class_1799 pushedItem) {
        return !CopperHopperMod.containsAtLeast(into, pushedItem, 1, this.nbtMatchEnabledIds);
    }

    public boolean shouldVetoPullInto(class_1263 into, class_1799 pulledItem) {
        return CopperHopperMod.isCopperHopper(into) && !CopperHopperMod.containsAtLeast(into, pulledItem, 1, this.nbtMatchEnabledIds);
    }

    public boolean shouldVetoPullFrom(CopperInventory from, class_1799 pulledItem) {
        return !CopperHopperMod.containsAtLeast(from, pulledItem, 2, this.nbtMatchEnabledIds);
    }

    public boolean shouldVetoPushFrom(class_1263 from, class_1799 pushedItem, class_1937 world, class_2338 pos) {
        if (!CopperHopperMod.isCopperHopper(from)) {
            return false;
        }
        if (!CopperHopperMod.containsAtLeast(from, pushedItem, 2, this.nbtMatchEnabledIds)) {
            return true;
        }
        if (((CopperHopperBlockEntity)from).method_11010().method_11654((class_2769)class_2377.field_11129) == class_2350.field_11033) {
            return false;
        }
        class_2338 below = pos.method_25503().method_30513(class_2350.class_2351.field_11052, -1);
        class_2586 blockEntity = world.method_8321(below);
        if (!CopperHopperMod.isCopperHopper(blockEntity)) {
            return false;
        }
        return CopperHopperMod.containsAtLeast((class_1263)blockEntity, pushedItem, 1, this.nbtMatchEnabledIds);
    }

    private static boolean isCopperHopper(class_1263 target) {
        return target instanceof CopperInventory;
    }

    private static boolean isCopperHopper(class_2586 blockEntity) {
        return blockEntity instanceof CopperHopperBlockEntity;
    }

    private static boolean containsAtLeast(class_1263 inventory, class_1799 inputItem, int atLeast, Collection<class_2960> nbtMatchEnabledIds) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 filterStack = inventory.method_5438(i);
            if (!CopperHopperMod.isMatch(filterStack, inputItem, nbtMatchEnabledIds) || (count += filterStack.method_7947()) < atLeast) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatch(class_1799 first, class_1799 second, Collection<class_2960> nbtMatchEnabledIds) {
        if (second.method_7960() || first.method_7960()) {
            return false;
        }
        if (first == second) {
            return true;
        }
        return first.method_31574(second.method_7909()) && (!nbtMatchEnabledIds.contains(class_7923.field_41178.method_10221((Object)first.method_7909())) || CopperHopperMod.areNbtEqual(first, second));
    }

    private static boolean areNbtEqual(class_1799 left, class_1799 right) {
        if (left.method_7960() && right.method_7960()) {
            return true;
        }
        if (!left.method_7960() && !right.method_7960()) {
            class_9326 leftData = left.method_57380();
            class_9326 rightData = right.method_57380();
            return leftData != null && leftData.equals((Object)rightData);
        }
        return false;
    }

    private void setLogLevel(Level logLevel) {
        Configurator.setLevel((String)CopperHopperMod.class.getName(), (Level)logLevel);
    }

    private static final class SingletonHolder {
        private static final CopperHopperMod INSTANCE = new CopperHopperMod();

        private SingletonHolder() {
        }
    }
}

