/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.data.DebugDataManager;
import fi.dy.masa.minihud.network.ServuxDebugPacket;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_634;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public abstract class ServuxDebugHandler<T extends class_8710>
implements IPluginClientPlayHandler<T> {
    private static final ServuxDebugHandler<ServuxDebugPacket.Payload> INSTANCE = new ServuxDebugHandler<ServuxDebugPacket.Payload>(){

        public void receive(ServuxDebugPacket.Payload payload, ClientPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final class_2960 CHANNEL_ID = class_2960.method_60655((String)"servux", (String)"debug_service");
    private boolean servuxRegistered;
    private boolean payloadRegistered = false;
    private int failures = 0;
    private static final int MAX_FAILURES = 4;

    public static ServuxDebugHandler<ServuxDebugPacket.Payload> getInstance() {
        return INSTANCE;
    }

    public class_2960 getPayloadChannel() {
        return CHANNEL_ID;
    }

    public boolean isPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    public void setPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    public <P extends IClientPayloadData> void decodeClientData(class_2960 channel, P data) {
        ServuxDebugPacket packet = (ServuxDebugPacket)data;
        if (!channel.equals((Object)CHANNEL_ID) || packet == null) {
            return;
        }
        if (Objects.requireNonNull(packet.getType()) == ServuxDebugPacket.Type.PACKET_S2C_METADATA) {
            if (DebugDataManager.getInstance().receiveMetadata(packet.getCompound())) {
                this.servuxRegistered = true;
            }
        } else {
            MiniHUD.logger.warn("ServuxDebugHandler#decodeClientData(): received unhandled packetType {} of size {} bytes.", (Object)packet.getPacketType(), (Object)packet.getTotalSize());
        }
    }

    public void reset(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.servuxRegistered) {
            this.servuxRegistered = false;
            this.failures = 0;
        }
    }

    public void resetFailures(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.failures > 0) {
            this.failures = 0;
        }
    }

    public void encodeWithSplitter(class_2540 buf, class_634 handler) {
    }

    public void receivePlayPayload(T payload, ClientPlayNetworking.Context ctx) {
        if (payload.method_56479().comp_2242().equals((Object)CHANNEL_ID)) {
            INSTANCE.decodeClientData(CHANNEL_ID, ((ServuxDebugPacket.Payload)payload).data());
        }
    }

    public <P extends IClientPayloadData> void encodeClientData(P data) {
        ServuxDebugPacket packet = (ServuxDebugPacket)data;
        if (!INSTANCE.sendPlayPayload(new ServuxDebugPacket.Payload(packet))) {
            if (this.failures > 4) {
                MiniHUD.printDebug("encodeClientData(): encountered [{}] sendPayload failures, cancelling any Servux join attempt(s)", 4);
                this.servuxRegistered = false;
                INSTANCE.unregisterPlayReceiver();
                DebugDataManager.getInstance().onPacketFailure();
            } else {
                ++this.failures;
            }
        }
    }
}

