/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.mixin.IMixinMerchantEntity;
import fi.dy.masa.minihud.mixin.IMixinZombieVillagerEntity;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.util.EntityUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3852;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;

public class OverlayRendererVillagerInfo
extends OverlayRendererBase {
    public static final OverlayRendererVillagerInfo INSTANCE = new OverlayRendererVillagerInfo();

    @Override
    public String getName() {
        return "Villager Info Overlay";
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_VILLAGER_INFO.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        return true;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        class_238 box = entity.method_5829().method_1009(30.0, 10.0, 30.0);
        class_1937 world = WorldUtils.getBestWorld((class_310)mc);
        if (world == null) {
            return;
        }
        if (Configs.Generic.VILLAGER_OFFER_ENCHANTMENT_BOOKS.getBooleanValue()) {
            List<class_1646> librarians = EntityUtils.getEntitiesByClass(mc, class_1646.class, box, villager -> villager.method_7231().method_16924() == class_3852.field_17060);
            HashMap<Object2IntMap.Entry, Integer> lowestPrices = new HashMap<Object2IntMap.Entry, Integer>();
            if (Configs.Generic.VILLAGER_OFFER_LOWEST_PRICE_NEARBY.getBooleanValue()) {
                for (class_1646 librarian : librarians) {
                    class_1916 offers = ((IMixinMerchantEntity)librarian).minihud_offers();
                    if (offers == null) continue;
                    for (class_1914 tradeOffer : offers) {
                        if (tradeOffer.method_8250().method_7909() != class_1802.field_8598 || tradeOffer.method_57556().comp_2424().comp_349() != class_1802.field_8687) continue;
                        for (Object2IntMap.Entry entry : ((class_9304)tradeOffer.method_8250().method_57825(class_9334.field_49643, null)).method_57539()) {
                            int emeraldCost = tradeOffer.method_57556().comp_2425();
                            if (lowestPrices.containsKey(entry)) {
                                if (emeraldCost >= (Integer)lowestPrices.get(entry)) continue;
                                lowestPrices.put(entry, emeraldCost);
                                continue;
                            }
                            lowestPrices.put(entry, emeraldCost);
                        }
                    }
                }
            }
            for (class_1646 librarian : librarians) {
                if (librarian.method_38069()) {
                    EntitiesDataManager.getInstance().requestEntity(world, librarian.method_5628());
                }
                ArrayList<String> overlay = new ArrayList<String>();
                class_1916 offers = ((IMixinMerchantEntity)librarian).minihud_offers();
                if (offers == null) continue;
                for (class_1914 tradeOffer : offers) {
                    if (tradeOffer.method_8250().method_7909() != class_1802.field_8598) continue;
                    for (Object2IntMap.Entry entry : ((class_9304)tradeOffer.method_8250().method_57825(class_9334.field_49643, (Object)class_9304.field_49385)).method_57539()) {
                        StringBuilder sb = new StringBuilder();
                        if (((class_1887)((class_6880)entry.getKey()).comp_349()).method_8183() == entry.getIntValue()) {
                            sb.append(GuiBase.TXT_GOLD);
                        } else if (Configs.Generic.VILLAGER_OFFER_HIGHEST_LEVEL_ONLY.getBooleanValue()) continue;
                        sb.append(class_1887.method_8179((class_6880)((class_6880)entry.getKey()), (int)entry.getIntValue()).getString());
                        sb.append(GuiBase.TXT_RST);
                        if (tradeOffer.method_57556().comp_2424().comp_349() == class_1802.field_8687) {
                            sb.append(" ");
                            int emeraldCost = tradeOffer.method_57556().comp_2425();
                            if (Configs.Generic.VILLAGER_OFFER_LOWEST_PRICE_NEARBY.getBooleanValue() && emeraldCost > lowestPrices.getOrDefault(entry, Integer.MAX_VALUE)) continue;
                            int lowest = 2 + 3 * entry.getIntValue();
                            int highest = 6 + 13 * entry.getIntValue();
                            if (((class_6880)entry.getKey()).method_40220(class_9636.field_51546)) {
                                lowest *= 2;
                                highest *= 2;
                            }
                            if ((double)emeraldCost > class_3532.method_16436((double)Configs.Generic.VILLAGER_OFFER_PRICE_THRESHOLD.getDoubleValue(), (double)lowest, (double)highest)) continue;
                            if ((double)emeraldCost < class_3532.method_16436((double)0.3333333333333333, (double)lowest, (double)highest)) {
                                sb.append(GuiBase.TXT_GREEN);
                            }
                            if ((double)emeraldCost > class_3532.method_16436((double)0.6666666666666666, (double)lowest, (double)highest)) {
                                sb.append(GuiBase.TXT_RED);
                            }
                            sb.append(emeraldCost);
                            if (Configs.Generic.VILLAGER_OFFER_PRICE_RANGE.getBooleanValue()) {
                                sb.append(' ').append('(').append(lowest).append('-').append(highest).append(')');
                            }
                            sb.append(GuiBase.TXT_RST);
                        }
                        overlay.add(sb.toString());
                    }
                }
                this.renderAtEntity(overlay, entity, (class_1297)librarian);
            }
        }
        if (Configs.Generic.VILLAGER_CONVERSION_TICKS.getBooleanValue()) {
            List<class_1641> zombieVillagers = EntityUtils.getEntitiesByClass(mc, class_1641.class, box, e -> true);
            for (class_1641 villager2 : zombieVillagers) {
                int conversionTimer;
                if (villager2.method_37908().field_9236) {
                    EntitiesDataManager.getInstance().requestEntity(world, villager2.method_5628());
                }
                if ((conversionTimer = ((IMixinZombieVillagerEntity)villager2).minihud_conversionTimer()) <= 0) continue;
                this.renderAtEntity(List.of(String.valueOf(conversionTimer)), entity, (class_1297)villager2);
            }
        }
    }

    private void renderAtEntity(List<String> texts, class_1297 entity, class_1297 targetEntity) {
        class_2338 pos;
        class_1309 living;
        Optional jobSite;
        float delta = class_310.method_1551().method_61966().method_60637(true);
        class_243 cameraPos = entity.method_30950(delta);
        class_243 targetPos = targetEntity.method_30950(delta);
        double hypot = class_3532.method_39241((double)(cameraPos.method_10216() - targetPos.method_10216()), (double)(cameraPos.method_10215() - targetPos.method_10215()));
        double distance = 0.8;
        double x = targetPos.method_10216() + (cameraPos.method_10216() - targetPos.method_10216()) / hypot * distance;
        double z = targetPos.method_10215() + (cameraPos.method_10215() - targetPos.method_10215()) / hypot * distance;
        double y = targetPos.method_10214() + 1.5 + 0.1 * (double)texts.size();
        if (targetEntity instanceof class_1309 && (jobSite = (living = (class_1309)targetEntity).method_18868().method_46873(class_4140.field_18439)) != null && jobSite.isPresent() && targetPos.method_1022((pos = ((class_4208)jobSite.get()).comp_2208()).method_46558()) < 1.7) {
            x = (double)pos.method_10263() + 0.5;
            z = (double)pos.method_10260() + 0.5;
        }
        for (String line : texts) {
            RenderUtils.drawTextPlate(List.of(line), (double)x, (double)y, (double)z, (float)0.02f);
            y -= 0.2;
        }
    }
}

