/*
 * Decompiled with CFR 0.152.
 */
package xyz.breadloaf.chamberfix.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9199;
import net.minecraft.class_9203;
import net.minecraft.class_9204;
import net.minecraft.class_9205;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.breadloaf.chamberfix.ChamberFix;
import xyz.breadloaf.chamberfix.ResetTimestampHolder;
import xyz.breadloaf.chamberfix.mixin.VaultServerDataAccessor;

@Mixin(value={class_9199.class})
public class VaultBlockEntityMixin
extends class_2586
implements ResetTimestampHolder {
    @Unique
    private final Map<UUID, Long> resetTimestamps = new HashMap<UUID, Long>();

    public VaultBlockEntityMixin(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    private void injectSaveAdditional(class_2487 compoundTag, class_7225.class_7874 provider, CallbackInfo ci) {
        if (this.resetTimestamps != null) {
            class_2499 resetTimers = new class_2499();
            for (Map.Entry<UUID, Long> entry : this.resetTimestamps.entrySet()) {
                class_2487 playerEntry = new class_2487();
                playerEntry.method_10544("time", entry.getValue().longValue());
                playerEntry.method_25927("uuid", entry.getKey());
                resetTimers.add((Object)playerEntry);
            }
            compoundTag.method_10566("reset_timestamps", (class_2520)resetTimers);
        }
    }

    @Inject(method={"loadAdditional"}, at={@At(value="HEAD")})
    private void injectLoadAdditional(class_2487 compoundTag, class_7225.class_7874 provider, CallbackInfo ci) {
        class_2499 listTag = compoundTag.method_10554("reset_timestamps", 10);
        this.resetTimestamps.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 playerEntry = listTag.method_10602(i);
            this.resetTimestamps.put(playerEntry.method_25926("uuid"), playerEntry.method_10537("time"));
        }
    }

    @Override
    public Map<UUID, Long> chamber_fix$getResetTimestamps() {
        return this.resetTimestamps;
    }

    @Mixin(value={class_9199.class_9201.class})
    public static class ServerMixin {
        @Inject(method={"tryInsertKey"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/vault/VaultBlockEntity$Server;unlock(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/vault/VaultConfig;Lnet/minecraft/world/level/block/entity/vault/VaultServerData;Lnet/minecraft/world/level/block/entity/vault/VaultSharedData;Ljava/util/List;)V")})
        private static void injectUnlock(class_3218 level, class_2338 pos, class_2680 blockState, class_9203 vaultConfig, class_9204 vaultServerData, class_9205 vaultSharedData, class_1657 player, class_1799 itemStack, CallbackInfo ci) {
            class_2586 blockEntity = level.method_8321(pos);
            if (!(blockEntity instanceof ResetTimestampHolder)) {
                return;
            }
            ResetTimestampHolder resetTimestampHolder = (ResetTimestampHolder)blockEntity;
            resetTimestampHolder.chamber_fix$getResetTimestamps().put(player.method_5667(), level.method_8510());
            VaultServerDataAccessor accessor = (VaultServerDataAccessor)vaultServerData;
            accessor.setIsDirty(true);
        }

        @Inject(method={"tick"}, at={@At(value="HEAD")})
        private static void injectTick(class_3218 level, class_2338 pos, class_2680 blockState, class_9203 vaultConfig, class_9204 vaultServerData, class_9205 vaultSharedData, CallbackInfo ci) {
            class_2586 blockEntity = level.method_8321(pos);
            if (!(blockEntity instanceof ResetTimestampHolder)) {
                return;
            }
            ResetTimestampHolder resetTimestampHolder = (ResetTimestampHolder)blockEntity;
            Map<UUID, Long> resetTimestamps = resetTimestampHolder.chamber_fix$getResetTimestamps();
            VaultServerDataAccessor accessor = (VaultServerDataAccessor)vaultServerData;
            boolean isDirty = false;
            Set<UUID> uuids = accessor.getRewardedPlayers();
            for (UUID uuid : uuids) {
                Long timer = resetTimestamps.get(uuid);
                if (timer == null) {
                    timer = 0L;
                    isDirty = true;
                }
                if (timer < 0L) {
                    resetTimestamps.remove(uuid);
                    isDirty = true;
                    continue;
                }
                if (level.method_8510() <= timer + ChamberFix.CONFIG.resetTimeTicks.get()) continue;
                resetTimestamps.remove(uuid);
                isDirty = true;
            }
            if (isDirty) {
                uuids.clear();
                uuids.addAll(resetTimestamps.keySet());
                accessor.setIsDirty(true);
            }
        }
    }
}

