/*
 * Decompiled with CFR 0.152.
 */
package xyz.breadloaf.external.de.maxhenkel.configbuilder.entry;

import java.util.Objects;
import javax.annotation.Nullable;
import xyz.breadloaf.external.de.maxhenkel.configbuilder.CommentedPropertyConfig;
import xyz.breadloaf.external.de.maxhenkel.configbuilder.Config;
import xyz.breadloaf.external.de.maxhenkel.configbuilder.entry.ConfigEntry;
import xyz.breadloaf.external.de.maxhenkel.configbuilder.entry.serializer.ValueSerializer;

public abstract class AbstractConfigEntry<T>
implements ConfigEntry<T> {
    protected final CommentedPropertyConfig config;
    protected final ValueSerializer<T> serializer;
    protected String[] comments;
    protected String key;
    protected T def;
    @Nullable
    protected T value;

    public AbstractConfigEntry(CommentedPropertyConfig config, ValueSerializer<T> serializer, String[] comments, String key, T def) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(serializer);
        Objects.requireNonNull(comments);
        Objects.requireNonNull(key);
        Objects.requireNonNull(def);
        this.config = config;
        this.serializer = serializer;
        this.comments = comments;
        this.key = key;
        this.def = def;
    }

    public void reload() {
        if (this.config.getProperties().containsKey(this.key)) {
            T val = this.serializer.deserialize(this.config.getProperties().get(this.key));
            if (val == null) {
                this.reset();
            } else {
                this.value = this.fixValue(val);
                this.syncEntryToProperties();
            }
        } else {
            this.reset();
        }
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public AbstractConfigEntry<T> set(T value) {
        if (this.value != null && this.value.equals(value)) {
            return this;
        }
        this.value = this.fixValue(value);
        this.syncEntryToProperties();
        return this;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public AbstractConfigEntry<T> comment(String ... comments) {
        this.comments = comments;
        this.syncEntryToProperties();
        return this;
    }

    @Override
    public String[] getComments() {
        return this.comments;
    }

    @Override
    public ConfigEntry<T> reset() {
        this.value = this.def;
        this.syncEntryToProperties();
        return this;
    }

    private void syncEntryToProperties() {
        String serialized = this.serializer.serialize(this.value);
        if (serialized == null) {
            if (this.value == this.def) {
                throw new IllegalStateException("Failed to serialize default value");
            }
            this.reset();
            return;
        }
        this.config.getProperties().set(this.key, serialized, this.comments);
    }

    @Override
    public ConfigEntry<T> save() {
        this.config.save();
        return this;
    }

    @Override
    public ConfigEntry<T> saveSync() {
        this.config.saveSync();
        return this;
    }

    T fixValue(T value) {
        return value;
    }

    @Override
    public T getDefault() {
        return this.def;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    public ValueSerializer<T> getSerializer() {
        return this.serializer;
    }
}

