/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.init;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cz.futuretek.eldergrove.Eldergrove;
import cz.futuretek.eldergrove.init.ModCriteria;
import cz.futuretek.eldergrove.init.ModItems;
import cz.futuretek.eldergrove.item.QuestScrollItem;
import cz.futuretek.eldergrove.quest.Quest;
import cz.futuretek.eldergrove.quest.QuestCompletionMessages;
import cz.futuretek.eldergrove.quest.Quests;
import cz.futuretek.eldergrove.quest.Rewards;
import cz.futuretek.eldergrove.state.PlayerData;
import cz.futuretek.eldergrove.state.WorldState;
import cz.futuretek.eldergrove.utils.ScoreUtils;
import cz.futuretek.eldergrove.utils.Utils;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7157;

public class ModCommands {
    private static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eg").requires(src -> src.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"quest").then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            source.method_45068((class_2561)class_2561.method_43470((String)"Listing active quests..."));
            WorldState worldState = WorldState.getData(source.method_9211());
            worldState.getActiveQuestsWithUUID().forEach((uuid, questId) -> {
                Quest quest = Quests.getQuest(questId);
                String playerName = source.method_9211().method_3793().method_14512(uuid).map(GameProfile::getName).orElse("Unknown Player");
                source.method_45068((class_2561)class_2561.method_43470((String)(quest.getTitle() + " (" + playerName + ")")));
            });
            return 1;
        }))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"questID", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Quests.QUESTS.forEach((s, quest) -> builder.suggest(s));
            return builder.buildFuture();
        }).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 entity = class_2186.method_9315((CommandContext)ctx, (String)"entity");
            String questID = StringArgumentType.getString((CommandContext)ctx, (String)"questID");
            Quest quest = Quests.getQuest(questID);
            if (Quests.getQuest(questID) == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + questID + " does not exist.")));
                return 1;
            }
            WorldState worldState = WorldState.getData(entity.method_5682());
            if (worldState.isQuestCompleted(questID)) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + questID + " is already marked as completed.")));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("Giving quest " + quest.getTitle() + " to " + entity.method_5477().getString())));
            Utils.givePlayerItem(entity, QuestScrollItem.createQuestItemStack(questID));
            return 1;
        }))))).then(class_2170.method_9247((String)"giveActive").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 entity = class_2186.method_9315((CommandContext)ctx, (String)"entity");
            PlayerData playerData = WorldState.getPlayerState((class_1309)entity);
            String questID = playerData.activeQuest;
            if (questID == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("No active quest for " + entity.method_5477().getString())));
                return 1;
            }
            Quest quest = Quests.getQuest(questID);
            if (Quests.getQuest(questID) == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + questID + " does not exist.")));
                return 1;
            }
            WorldState worldState = WorldState.getData(entity.method_5682());
            if (worldState.isQuestCompleted(questID)) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + questID + " is already marked as completed.")));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("Giving quest " + quest.getTitle() + " to " + entity.method_5477().getString())));
            Utils.givePlayerItem(entity, QuestScrollItem.createQuestItemStack(questID));
            return 1;
        })))).then(class_2170.method_9247((String)"complete").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"questID", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Quests.QUESTS.forEach((s, quest) -> builder.suggest(s));
            return builder.buildFuture();
        }).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 entity = class_2186.method_9315((CommandContext)ctx, (String)"entity");
            String questID = StringArgumentType.getString((CommandContext)ctx, (String)"questID");
            if (Quests.getQuest(questID) == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + questID + " does not exist.")));
                return 1;
            }
            WorldState worldState = WorldState.getData(entity.method_5682());
            if (worldState.isQuestCompleted(questID)) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + questID + " is already marked as completed.")));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("Completing quest " + questID)));
            worldState.markAsCompleted(questID, (class_1309)entity);
            return 1;
        }))))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"questID", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Quests.QUESTS.forEach((s, quest) -> builder.suggest(s));
            return builder.buildFuture();
        }).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            String questID = StringArgumentType.getString((CommandContext)ctx, (String)"questID");
            if (Quests.getQuest(questID) == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + questID + " does not exist.")));
                return 1;
            }
            WorldState worldState = WorldState.getData(source.method_9211());
            if (!worldState.isQuestCompleted(questID)) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + questID + " is not marked as completed.")));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("Resetting quest " + questID)));
            worldState.markAsReset(questID);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"points").then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 entity = class_2186.method_9315((CommandContext)ctx, (String)"entity");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            source.method_45068((class_2561)class_2561.method_43470((String)("Setting quest points of " + entity.method_5477().getString() + " to " + amount)));
            PlayerData playerData = WorldState.getPlayerState((class_1309)entity);
            playerData.points = amount;
            class_266 objective = ScoreUtils.getOrCreateObjective((class_3218)entity.method_37908(), "questPoints", "Quest points");
            ScoreUtils.getPlayerScoreAccess((class_3218)entity.method_37908(), entity, objective).method_55410(amount);
            return 1;
        }))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 entity = class_2186.method_9315((CommandContext)ctx, (String)"entity");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            source.method_45068((class_2561)class_2561.method_43470((String)("Adding " + amount + " quest points to " + entity.method_5477().getString())));
            PlayerData playerData = WorldState.getPlayerState((class_1309)entity);
            playerData.points = playerData.points + amount;
            class_266 objective = ScoreUtils.getOrCreateObjective((class_3218)entity.method_37908(), "questPoints", "Quest points");
            ScoreUtils.getPlayerScoreAccess((class_3218)entity.method_37908(), entity, objective).method_55414(amount);
            return 1;
        }))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 entity = class_2186.method_9315((CommandContext)ctx, (String)"entity");
            PlayerData playerData = WorldState.getPlayerState((class_1309)entity);
            source.method_45068((class_2561)class_2561.method_43470((String)("Player " + entity.method_5477().getString() + " has " + playerData.points + " points")));
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reward").then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            source.method_45068((class_2561)class_2561.method_43470((String)"Listing all rewards..."));
            Rewards.REWARDS.forEach((id, reward) -> source.method_45068((class_2561)class_2561.method_43470((String)("ID: " + id + " - " + reward.getTitle()))));
            return 1;
        }))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"reward", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Rewards.REWARDS.forEach((s, reward) -> builder.suggest(s));
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"unlocked", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 entity = class_2186.method_9315((CommandContext)ctx, (String)"entity");
            String reward = StringArgumentType.getString((CommandContext)ctx, (String)"reward");
            boolean unlocked = BoolArgumentType.getBool((CommandContext)ctx, (String)"unlocked");
            if (!Rewards.REWARDS.containsKey(reward)) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Reward " + reward + " does not exist.")));
                return 1;
            }
            PlayerData playerData = WorldState.getPlayerState((class_1309)entity);
            if (unlocked && playerData.rewards.contains(reward)) {
                source.method_9213((class_2561)class_2561.method_43470((String)(entity.method_5477().getString() + " already has reward " + reward + " unlocked.")));
                return 1;
            }
            if (!unlocked && !playerData.rewards.contains(reward)) {
                source.method_9213((class_2561)class_2561.method_43470((String)(entity.method_5477().getString() + " does not have reward " + reward + " unlocked.")));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("Setting reward " + reward + " for " + entity.method_5477().getString() + " to " + (unlocked ? "unlocked" : "locked"))));
            if (unlocked) {
                playerData.rewards.add(reward);
                Rewards.getReward(reward).onEnable(source.method_44023());
            } else {
                playerData.rewards.remove(reward);
            }
            return 1;
        })))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"quest").then(class_2170.method_9247((String)"active").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            PlayerData playerData = WorldState.getPlayerState((class_1309)source.method_44023());
            if (playerData.activeQuest == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"You have no active quest."));
                return 1;
            }
            Quest quest = Quests.getQuest(playerData.activeQuest);
            if (quest == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + playerData.activeQuest + " does not exist.")));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("You have active quest " + quest.getTitle())));
            return 1;
        }))).then(class_2170.method_9247((String)"give").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            PlayerData playerData = WorldState.getPlayerState((class_1309)source.method_44023());
            if (playerData.activeQuest == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"You have no active quest."));
                return 1;
            }
            source.method_45068((class_2561)class_2561.method_43470((String)("Giving copy of the quest scroll to " + source.method_44023().method_5477().getString())));
            Utils.givePlayerItem(source.method_44023(), QuestScrollItem.createQuestItemStack(playerData.activeQuest));
            return 1;
        }))).then(class_2170.method_9247((String)"complete").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 entity = source.method_44023();
            WorldState worldState = WorldState.getData(entity.method_5682());
            PlayerData playerData = WorldState.getPlayerState((class_1309)entity);
            if (playerData.activeQuest == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"You have no active quest."));
                return 1;
            }
            if (worldState.isQuestCompleted(playerData.activeQuest)) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + playerData.activeQuest + " is already marked as completed.")));
                return 1;
            }
            Quest quest = Quests.getQuest(playerData.activeQuest);
            if (quest == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Quest " + playerData.activeQuest + " does not exist.")));
                return 1;
            }
            int slot = source.method_44023().method_31548().method_61494((class_6880)ModItems.QUEST_SCROLL.method_40131(), QuestScrollItem.createQuestItemStack(playerData.activeQuest));
            if (slot != -1) {
                source.method_44023().method_31548().method_5447(slot, class_1799.field_8037);
            }
            worldState.markAsCompleted(quest.getId(), (class_1309)entity);
            PlayerData playerData2 = playerData;
            playerData2.points = playerData2.points + quest.getPoints();
            class_266 objective = ScoreUtils.getOrCreateObjective((class_3218)entity.method_37908(), "questPoints", "Quest points");
            ScoreUtils.getPlayerScoreAccess((class_3218)entity.method_37908(), entity, objective).method_55414(quest.getPoints().intValue());
            ModCriteria.QUEST_COMPLETE.trigger(entity);
            String playerName = entity.method_5477().getString();
            String questTitle = quest.getTitle();
            class_2561 completionMessage = class_2561.method_30163((String)QuestCompletionMessages.getRandomMessage(playerName, questTitle));
            for (class_3222 serverPlayer : ((class_3218)entity.method_37908()).method_18456()) {
                serverPlayer.method_7353(completionMessage, false);
            }
            return 1;
        })));
    }

    public static void initialize() {
        Eldergrove.LOGGER.info("Registering commands for eldergrove");
        CommandRegistrationCallback.EVENT.register(ModCommands::registerCommands);
    }
}

