/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.init;

import cz.futuretek.eldergrove.Eldergrove;
import cz.futuretek.eldergrove.init.ModSounds;
import cz.futuretek.eldergrove.item.AreaMiningToolItem;
import cz.futuretek.eldergrove.item.QuestScrollItem;
import cz.futuretek.eldergrove.network.DashCooldownPayload;
import cz.futuretek.eldergrove.network.DashPayload;
import cz.futuretek.eldergrove.network.OpenNpcScreenPayload;
import cz.futuretek.eldergrove.network.OpenRewardsScreenPayload;
import cz.futuretek.eldergrove.network.OpenWitchScreenPayload;
import cz.futuretek.eldergrove.network.QuestMarkAsCompletedPayload;
import cz.futuretek.eldergrove.network.QuestObtainPayload;
import cz.futuretek.eldergrove.network.RewardScreenDataPayload;
import cz.futuretek.eldergrove.network.ToggleMagnetPayload;
import cz.futuretek.eldergrove.network.ToolOffsetChangePayload;
import cz.futuretek.eldergrove.network.UnlockRewardPayload;
import cz.futuretek.eldergrove.quest.Rewards;
import cz.futuretek.eldergrove.state.PlayerData;
import cz.futuretek.eldergrove.state.WorldState;
import cz.futuretek.eldergrove.utils.DashAction;
import cz.futuretek.eldergrove.utils.MagnetUtils;
import cz.futuretek.eldergrove.utils.Utils;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_8710;

public class ModNetworkServerReceivers {
    public static void initialize() {
        Eldergrove.LOGGER.info("Registering server receivers for eldergrove");
        PayloadTypeRegistry.playS2C().register(RewardScreenDataPayload.ID, RewardScreenDataPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(OpenNpcScreenPayload.ID, OpenNpcScreenPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(OpenWitchScreenPayload.ID, OpenWitchScreenPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(DashCooldownPayload.ID, DashCooldownPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(OpenRewardsScreenPayload.ID, OpenRewardsScreenPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(UnlockRewardPayload.ID, UnlockRewardPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(QuestMarkAsCompletedPayload.ID, QuestMarkAsCompletedPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(QuestObtainPayload.ID, QuestObtainPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ToggleMagnetPayload.ID, ToggleMagnetPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ToolOffsetChangePayload.ID, ToolOffsetChangePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(DashPayload.ID, DashPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(OpenRewardsScreenPayload.ID, (customPayload, context) -> context.server().execute(() -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof class_3222) {
                class_3222 serverPlayer = patt0$temp;
                PlayerData playerData = WorldState.getPlayerState((class_1309)serverPlayer);
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new RewardScreenDataPayload(playerData.rewards, playerData.points));
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(UnlockRewardPayload.ID, (customPayload, context) -> context.server().execute(() -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof class_3222) {
                class_3222 serverPlayer = patt0$temp;
                Rewards.unlockReward(serverPlayer, customPayload.rewardId());
                serverPlayer.method_17356(ModSounds.GRACIEE_REWARD, class_3419.field_15254, 1.0f, 1.0f);
                PlayerData playerData = WorldState.getPlayerState((class_1309)serverPlayer);
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new RewardScreenDataPayload(playerData.rewards, playerData.points));
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(QuestMarkAsCompletedPayload.ID, (customPayload, context) -> context.server().execute(() -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof class_3222) {
                class_3222 serverPlayer = patt0$temp;
                class_1799 itemStack = serverPlayer.method_5998(serverPlayer.method_6058());
                class_1792 patt1$temp = itemStack.method_7909();
                if (patt1$temp instanceof QuestScrollItem) {
                    QuestScrollItem questScrollItem = (QuestScrollItem)patt1$temp;
                    questScrollItem.markAsCompleted(itemStack, (class_1657)serverPlayer);
                }
                serverPlayer.method_17356(ModSounds.GRACIEE_COMPLETE, class_3419.field_15254, 1.0f, 1.0f);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(QuestObtainPayload.ID, (customPayload, context) -> context.server().execute(() -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof class_3222) {
                class_3222 serverPlayer = patt0$temp;
                class_1799 questScroll = QuestScrollItem.createQuestItemStack(customPayload.questId());
                Utils.givePlayerItem(serverPlayer, questScroll);
                WorldState worldState = WorldState.getData(serverPlayer.field_13995);
                worldState.markAsActive(customPayload.questId(), (class_1309)serverPlayer);
                serverPlayer.method_17356(ModSounds.GRACIEE_START, class_3419.field_15254, 1.0f, 1.0f);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(ToggleMagnetPayload.ID, (customPayload, context) -> context.server().execute(() -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof class_3222) {
                class_3222 playerEntity = patt0$temp;
                MagnetUtils.toggleMagnet(playerEntity);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(ToolOffsetChangePayload.ID, (customPayload, context) -> context.server().execute(() -> {
            class_1792 patt1$temp;
            class_3222 patt0$temp = context.player();
            if (!(patt0$temp instanceof class_3222)) {
                return;
            }
            class_3222 serverPlayer = patt0$temp;
            class_1799 mainHandStack = serverPlayer.method_6047();
            if (mainHandStack.method_7960() || !((patt1$temp = mainHandStack.method_7909()) instanceof AreaMiningToolItem)) {
                return;
            }
            AreaMiningToolItem tool = (AreaMiningToolItem)patt1$temp;
            int toolRange = tool.getToolRange(mainHandStack, context.player().method_37908());
            if (customPayload.offsetX() > toolRange || customPayload.offsetX() < -toolRange) {
                return;
            }
            if (customPayload.offsetY() > toolRange || customPayload.offsetY() < -toolRange) {
                return;
            }
            tool.setOffsetX(mainHandStack, customPayload.offsetX());
            tool.setOffsetY(mainHandStack, customPayload.offsetY());
            serverPlayer.method_31548().method_5431();
        }));
        ServerPlayNetworking.registerGlobalReceiver(DashPayload.ID, (customPayload, context) -> context.server().execute(() -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof class_3222) {
                class_3222 playerEntity = patt0$temp;
                DashAction.doAction(playerEntity);
            }
        }));
    }
}

