/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.item;

import cz.futuretek.eldergrove.init.ModComponents;
import cz.futuretek.eldergrove.init.ModTags;
import cz.futuretek.eldergrove.state.DemagnetizerManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9886;

public class MagnetItem
extends class_1792 {
    public static final double BASE_MAGNET_RANGE = 8.0;
    public static final double ENCHANT_RANGE_MODIFIER = 2.0;
    private static final double BASE_PULL_SPEED = 0.1;
    private static final double MAX_PULL_SPEED = 1.0;
    private static final int MAX_PULL_TIME = 100;
    private final Map<UUID, Integer> itemTimers = new HashMap<UUID, Integer>();

    public MagnetItem(class_9886 material, class_1792.class_1793 settings) {
        super(settings.method_7889(1).method_24359().method_7895(material.comp_2931() * 4).method_61647(material.comp_2935()).method_61649(material.comp_2934()).method_57349(ModComponents.ACTIVE, (Object)false));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_5250 status = MagnetItem.isBroken(stack) ? class_2561.method_43471((String)"itemTooltip.eldergrove.magnet_item.broken").method_27692(class_124.field_1079) : (MagnetItem.isActive(stack) ? class_2561.method_43471((String)"itemTooltip.eldergrove.magnet_item.active").method_27692(class_124.field_1060) : class_2561.method_43471((String)"itemTooltip.eldergrove.magnet_item.inactive").method_27692(class_124.field_1061));
        tooltip.add((class_2561)class_2561.method_43469((String)"itemTooltip.eldergrove.magnet_item.status", (Object[])new Object[]{status}));
        int powerLevel = MagnetItem.getPowerLevel(context, stack);
        int magnetRange = (int)(8.0 + (double)powerLevel * 2.0);
        tooltip.add((class_2561)class_2561.method_43469((String)"itemTooltip.eldergrove.magnet_item.range", (Object[])new Object[]{magnetRange}).method_27692(class_124.field_1078));
        super.method_7851(stack, context, tooltip, type);
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        return enchantment.method_40220(ModTags.Enchantments.MAGNET_ENCHANTABLE);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_1269.field_5812;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (entity.method_7325()) {
            return;
        }
        if (!world.method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (MagnetItem.isActive(stack) && !MagnetItem.isBroken(stack) && !DemagnetizerManager.get((class_3218)world).isNearActiveDemagnetizer(entity.method_24515(), 32)) {
                this.pullNearbyItems((class_3218)world, player, stack);
            }
        }
    }

    public static boolean isBroken(class_1799 stack) {
        return stack.method_7919() >= stack.method_7936();
    }

    public static boolean isActive(class_1799 stack) {
        return (Boolean)stack.method_57825(ModComponents.ACTIVE, (Object)false);
    }

    public static void setIsActive(class_1799 stack, boolean isActive) {
        stack.method_57379(ModComponents.ACTIVE, (Object)isActive);
    }

    public void pullNearbyItems(class_3218 world, class_1657 player, class_1799 stack) {
        class_243 playerPos = player.method_19538();
        int powerLevel = MagnetItem.getPowerLevel(world, stack);
        double magnetRange = 8.0 + (double)powerLevel * 2.0;
        List items = world.method_8390(class_1542.class, player.method_5829().method_1014(magnetRange), entity -> entity.method_5805());
        for (class_1542 itemEntity : items) {
            UUID itemId = itemEntity.method_5667();
            this.itemTimers.put(itemId, this.itemTimers.getOrDefault(itemId, 0) + 1);
            int timeInRange = Math.min(this.itemTimers.get(itemId), 100);
            double pullSpeed = 0.1 + 0.9 * (double)timeInRange / 100.0;
            class_243 itemPos = itemEntity.method_19538();
            class_243 pullDirection = playerPos.method_1020(itemPos).method_1029();
            class_243 velocity = itemEntity.method_18798().method_1019(pullDirection.method_1021(pullSpeed += (double)powerLevel * 0.05));
            itemEntity.method_18799(velocity);
            if (!(playerPos.method_1022(itemPos) <= 0.8)) continue;
            itemEntity.method_6982(0);
        }
        this.itemTimers.keySet().removeIf(uuid -> items.stream().noneMatch(item -> item.method_5667().equals(uuid)));
    }

    public static int getPowerLevel(class_3218 world, class_1799 stack) {
        class_2378 reg = world.method_30349().method_30530(class_7924.field_41265);
        return class_1890.method_8225((class_6880)reg.method_46747(class_1893.field_9103), (class_1799)stack);
    }

    public static int getPowerLevel(class_1792.class_9635 context, class_1799 stack) {
        class_6880.class_6883 enchant = context.method_59527().method_46762(class_7924.field_41265).method_46747(class_1893.field_9103);
        return class_1890.method_8225((class_6880)enchant, (class_1799)stack);
    }
}

