/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.item;

import cz.futuretek.eldergrove.init.ModComponents;
import cz.futuretek.eldergrove.init.ModCriteria;
import cz.futuretek.eldergrove.init.ModItems;
import cz.futuretek.eldergrove.quest.Quest;
import cz.futuretek.eldergrove.quest.QuestCompletionMessages;
import cz.futuretek.eldergrove.quest.Quests;
import cz.futuretek.eldergrove.screen.QuestScreen;
import cz.futuretek.eldergrove.state.PlayerData;
import cz.futuretek.eldergrove.state.WorldState;
import cz.futuretek.eldergrove.utils.ScoreUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_9323;

public class QuestScrollItem
extends class_1792 {
    public QuestScrollItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static class_1799 createQuestItemStack(String questId) {
        class_1799 questScrollItem = new class_1799((class_1935)ModItems.QUEST_SCROLL);
        questScrollItem.method_57365(class_9323.method_57827().method_57840(ModComponents.QUEST_ID, (Object)questId).method_57838());
        return questScrollItem;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.method_8608()) {
            class_1799 itemStack = user.method_5998(hand);
            Quest quest = this.getQuest(itemStack);
            class_310.method_1551().method_1507((class_437)new QuestScreen(quest));
        }
        return class_1269.field_5812;
    }

    public Quest getQuest(class_1799 stack) {
        String questId = (String)stack.method_57824(ModComponents.QUEST_ID);
        return Quests.getQuest(questId);
    }

    public void markAsCompleted(class_1799 stack, class_1657 player) {
        Quest quest;
        if (!player.method_37908().field_9236 && player.method_5682() != null && (quest = this.getQuest(stack)) != null) {
            if (player.method_6047() == stack) {
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
            } else if (player.method_6079() == stack) {
                player.method_6122(class_1268.field_5810, class_1799.field_8037);
            }
            WorldState completedQuestState = WorldState.getData(player.method_5682());
            PlayerData playerState = WorldState.getPlayerState((class_1309)player);
            if (playerState.activeQuest == null || !playerState.activeQuest.equals(quest.getId())) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Quest has already been completed.").method_27692(class_124.field_1061), false);
                return;
            }
            completedQuestState.markAsCompleted(quest.getId(), (class_1309)player);
            PlayerData playerData = playerState;
            playerData.points = playerData.points + quest.getPoints();
            class_266 objective = ScoreUtils.getOrCreateObjective((class_3218)player.method_37908(), "questPoints", "Quest points");
            ScoreUtils.getPlayerScoreAccess((class_3218)player.method_37908(), (class_3222)player, objective).method_55414(quest.getPoints().intValue());
            ModCriteria.QUEST_COMPLETE.trigger((class_3222)player);
            String playerName = player.method_5477().getString();
            String questTitle = quest.getTitle();
            class_2561 completionMessage = class_2561.method_30163((String)QuestCompletionMessages.getRandomMessage(playerName, questTitle));
            for (class_3222 serverPlayer : ((class_3218)player.method_37908()).method_18456()) {
                serverPlayer.method_7353(completionMessage, false);
            }
        }
    }
}

