/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.mixin;

import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_6854;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_758;
import net.minecraft.class_9958;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_758.class})
public abstract class PaleGardenFogMixin {
    @Unique
    private static final float FOG_SPEED = 0.003f;
    @Unique
    private static float fogDensity = 0.0f;

    @Inject(method={"applyFog"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectApplyFog(class_4184 camera, class_758.class_4596 fogType, Vector4f color, float viewDistance, boolean thickenFog, float tickDelta, CallbackInfoReturnable<class_9958> cir) {
        class_746 player = (class_746)camera.method_19331();
        class_638 world = (class_638)player.method_37908();
        class_6880 biomeEntry = world.method_23753(player.method_24515());
        long timeOfDay = world.method_8532() % 24000L;
        boolean showFog = biomeEntry.method_55840().equals("minecraft:pale_garden");
        float f = fogDensity = showFog ? Math.min(fogDensity + 0.003f, 1.0f) : Math.max(fogDensity - 0.003f, 0.0f);
        if (fogDensity > 0.0f) {
            Vector4f fogColor = PaleGardenFogMixin.calculateColor(color, fogDensity, timeOfDay);
            cir.setReturnValue((Object)new class_9958(2.0f, 15.0f, class_6854.field_36350, fogColor.x, fogColor.y, fogColor.z, fogColor.w));
            cir.cancel();
        }
    }

    @Unique
    private static Vector4f calculateColor(Vector4f color, float fogDensity, long timeOfDay) {
        float amplificationFactor = 8.0f;
        if (timeOfDay >= 13000L && timeOfDay <= 23000L) {
            float nightProgress = (float)(timeOfDay - 13000L) / 10000.0f;
            float proportionalAmplification = 1.0f + 7.0f * nightProgress;
            float red = class_3532.method_15363((float)(color.x * proportionalAmplification), (float)0.0f, (float)1.0f);
            float green = class_3532.method_15363((float)(color.y * proportionalAmplification), (float)0.0f, (float)1.0f);
            float blue = class_3532.method_15363((float)(color.z * proportionalAmplification), (float)0.0f, (float)1.0f);
            return new Vector4f(red, green, blue, fogDensity * 0.949f);
        }
        return new Vector4f(color.x, color.y, color.z, fogDensity * 0.949f);
    }
}

