/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.painting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import cz.futuretek.eldergrove.init.ModItems;
import cz.futuretek.eldergrove.init.ModTags;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1535;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_7988;
import org.jetbrains.annotations.Nullable;

public class GracieePaintingEntity
extends class_1530
implements class_7988<class_6880<class_1535>> {
    private static final class_2940<class_6880<class_1535>> VARIANT = class_2945.method_12791(GracieePaintingEntity.class, (class_2941)class_2943.field_39017);
    public static final MapCodec<class_6880<class_1535>> VARIANT_MAP_CODEC = class_1535.field_51597.fieldOf("variant");
    public static final Codec<class_6880<class_1535>> VARIANT_ENTRY_CODEC = VARIANT_MAP_CODEC.codec();

    public GracieePaintingEntity(class_1299<? extends GracieePaintingEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(VARIANT, (Object)((class_6880)this.method_56673().method_30530(class_7924.field_41209).method_60385().orElseThrow()));
    }

    public void method_5674(class_2940<?> data) {
        if (VARIANT.equals(data)) {
            this.method_6895();
        }
    }

    public void setVariant(class_6880<class_1535> variant) {
        this.field_6011.method_12778(VARIANT, variant);
    }

    public class_6880<class_1535> getVariant() {
        return (class_6880)this.field_6011.method_12789(VARIANT);
    }

    public static Optional<GracieePaintingEntity> placePainting(class_1937 world, class_2338 pos, class_2350 facing) {
        GracieePaintingEntity paintingEntity = new GracieePaintingEntity(world, pos);
        ArrayList<class_6880> variantList = new ArrayList<class_6880>();
        world.method_30349().method_30530(class_7924.field_41209).method_40286(ModTags.PaintingVariants.GRACIEE_ART).forEach(variantList::add);
        if (variantList.isEmpty()) {
            return Optional.empty();
        }
        paintingEntity.method_6892(facing);
        variantList.removeIf(variant -> {
            paintingEntity.setVariant((class_6880<class_1535>)variant);
            return !paintingEntity.method_6888();
        });
        if (variantList.isEmpty()) {
            return Optional.empty();
        }
        int maxSize = variantList.stream().mapToInt(GracieePaintingEntity::getSize).max().orElse(0);
        variantList.removeIf(variant -> GracieePaintingEntity.getSize((class_6880<class_1535>)variant) < maxSize);
        Optional selectedVariant = class_156.method_40083(variantList, (class_5819)paintingEntity.field_5974);
        if (selectedVariant.isEmpty()) {
            return Optional.empty();
        }
        paintingEntity.setVariant((class_6880<class_1535>)((class_6880)selectedVariant.get()));
        paintingEntity.method_6892(facing);
        return Optional.of(paintingEntity);
    }

    private static int getSize(class_6880<class_1535> variant) {
        return ((class_1535)variant.comp_349()).method_59947();
    }

    public GracieePaintingEntity(class_1937 world, class_2338 pos) {
        super(class_1299.field_6120, world, pos);
    }

    public GracieePaintingEntity(class_1937 world, class_2338 pos, class_2350 direction, class_6880<class_1535> variant) {
        this(world, pos);
        this.setVariant(variant);
        this.method_6892(direction);
    }

    public void method_5652(class_2487 nbt) {
        VARIANT_ENTRY_CODEC.encodeStart((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), this.getVariant()).ifSuccess(nbtElement -> nbt.method_10543((class_2487)nbtElement));
        nbt.method_10567("facing", (byte)this.field_7099.method_10161());
        super.method_5652(nbt);
    }

    public void method_5749(class_2487 nbt) {
        VARIANT_ENTRY_CODEC.parse((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).ifSuccess(this::setVariant);
        this.field_7099 = class_2350.method_10139((int)nbt.method_10571("facing"));
        super.method_5749(nbt);
        this.method_6892(this.field_7099);
    }

    protected class_238 method_59943(class_2338 pos, class_2350 side) {
        class_243 vec3d = class_243.method_24953((class_2382)pos).method_43206(side, -0.46875);
        class_1535 paintingVariant = (class_1535)this.getVariant().comp_349();
        double d = this.getOffset(paintingVariant.comp_2670());
        double e = this.getOffset(paintingVariant.comp_2671());
        class_2350 direction = side.method_10160();
        class_243 vec3d2 = vec3d.method_43206(direction, d).method_43206(class_2350.field_11036, e);
        class_2350.class_2351 axis = side.method_10166();
        double g = axis == class_2350.class_2351.field_11048 ? 0.0625 : (double)paintingVariant.comp_2670();
        double h = paintingVariant.comp_2671();
        double i = axis == class_2350.class_2351.field_11051 ? 0.0625 : (double)paintingVariant.comp_2670();
        return class_238.method_30048((class_243)vec3d2, (double)g, (double)h, (double)i);
    }

    private double getOffset(int length) {
        return length % 2 == 0 ? 0.5 : 0.0;
    }

    public void method_6889(class_3218 world, @Nullable class_1297 breaker) {
        if (world.method_64395().method_8355(class_1928.field_19393)) {
            class_1657 playerEntity;
            this.method_5783(class_3417.field_14809, 1.0f, 1.0f);
            if (breaker instanceof class_1657 && (playerEntity = (class_1657)breaker).method_56992()) {
                return;
            }
            this.method_5706(world, (class_1935)ModItems.GRACIEE_PAINTING);
        }
    }

    public void method_6894() {
        this.method_5783(class_3417.field_14875, 1.0f, 1.0f);
    }

    public void method_5808(double x, double y, double z, float yaw, float pitch) {
        this.method_5814(x, y, z);
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.method_5814(x, y, z);
    }

    public class_243 method_43390() {
        return class_243.method_24954((class_2382)this.field_51589);
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new class_2604((class_1297)this, this.field_7099.method_10146(), this.method_59940());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.method_6892(class_2350.method_10143((int)packet.method_11166()));
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)ModItems.GRACIEE_PAINTING);
    }
}

