/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cz.futuretek.eldergrove.Eldergrove;
import cz.futuretek.eldergrove.quest.Quest;
import cz.futuretek.eldergrove.state.WorldState;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_3222;

public class Quests {
    public static final Map<String, Quest> QUESTS = new HashMap<String, Quest>();

    public static void loadQuests() {
        String questsPath = "/data/eldergrove/quests.json";
        try (InputStream inputStream = Eldergrove.class.getResourceAsStream(questsPath);){
            if (inputStream == null) {
                Eldergrove.LOGGER.error("Could not find quests.json at path: " + questsPath);
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            JsonArray questArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            for (int i = 0; i < questArray.size(); ++i) {
                JsonObject questObject = questArray.get(i).getAsJsonObject();
                String id = questObject.get("id").getAsString();
                String title = questObject.get("title").getAsString();
                String description = questObject.get("description").getAsString();
                int tier = questObject.get("tier").getAsInt();
                int points = questObject.get("points").getAsInt();
                HashSet<String> dependsOn = new HashSet<String>();
                if (questObject.has("depends_on") && questObject.get("depends_on").isJsonArray()) {
                    JsonArray dependsArray = questObject.getAsJsonArray("depends_on");
                    for (int j = 0; j < dependsArray.size(); ++j) {
                        dependsOn.add(dependsArray.get(j).getAsString());
                    }
                }
                Quest quest = new Quest(id, title, description, tier, points, dependsOn);
                QUESTS.put(id, quest);
            }
            Eldergrove.LOGGER.info("Successfully loaded " + QUESTS.size() + " quests.");
        }
        catch (Exception e) {
            Eldergrove.LOGGER.error("Failed to load quests.json", (Throwable)e);
        }
    }

    public static Quest getQuest(String id) {
        if (!QUESTS.containsKey(id)) {
            return null;
        }
        return QUESTS.get(id);
    }

    public static String getRandomFreeQuest(class_3222 player) {
        WorldState worldState = WorldState.getData(player.method_5682());
        List<Quest> availableQuests = QUESTS.values().stream().filter(quest -> !worldState.getCompletedQuests().contains(quest.getId()) && !worldState.getActiveQuests().contains(quest.getId()) && worldState.getCompletedQuests().containsAll(quest.getDependsOn())).sorted(Comparator.comparingInt(Quest::getTier)).toList();
        int lowestTier = availableQuests.isEmpty() ? -1 : availableQuests.get(0).getTier();
        List<Quest> lowestTierQuests = availableQuests.stream().filter(quest -> quest.getTier() == lowestTier).toList();
        if (!lowestTierQuests.isEmpty()) {
            Random random = new Random();
            return lowestTierQuests.get(random.nextInt(lowestTierQuests.size())).getId();
        }
        return null;
    }
}

