/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.quest;

import cz.futuretek.eldergrove.Eldergrove;
import cz.futuretek.eldergrove.init.ModCriteria;
import cz.futuretek.eldergrove.init.ModItems;
import cz.futuretek.eldergrove.quest.Reward;
import cz.futuretek.eldergrove.quest.RewardApplyFunctionInterface;
import cz.futuretek.eldergrove.state.PlayerData;
import cz.futuretek.eldergrove.state.WorldState;
import cz.futuretek.eldergrove.utils.DashAction;
import cz.futuretek.eldergrove.utils.Utils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8786;

public class Rewards {
    public static Map<String, Reward> REWARDS = new LinkedHashMap<String, Reward>();
    public static final String GRACIUM_TOOLS = "gracium_tools";
    public static final String GRACIUM_WEAPONS = "gracium_weapons";
    public static final String GRACIUM_BARREL = "gracium_barrel";
    public static final String GRACIUM_ARMOR = "gracium_armor";
    public static final String GRACIUM_HORSE_ARMOR = "gracium_horse_armor";
    public static final String GRACIUM_WOLF_ARMOR = "gracium_wolf_armor";
    public static final String GRACIUM_HAMMER = "gracium_hammer";
    public static final String GRACIUM_EXCAVATOR = "gracium_excavator";
    public static final String GRACIUM_MAGNET = "gracium_magnet";
    public static final String GRACIEE_ART = "graciee_art";
    public static final String HASTE_POTION = "haste_potion";
    public static final String DASH = "dash";

    public static void init() {
        Rewards.register(GRACIUM_TOOLS, "Gracium Tools", "Unlocking this reward grants you the ability to craft the Gracium shovel, pickaxe, axe, and hoe, essential tools for your mining and farming needs.", (class_1935)ModItems.GRACIUM_PICKAXE, 4, List.of(class_2960.method_60654((String)"eldergrove:gracium_pickaxe"), class_2960.method_60654((String)"eldergrove:gracium_axe1"), class_2960.method_60654((String)"eldergrove:gracium_axe2"), class_2960.method_60654((String)"eldergrove:gracium_shovel"), class_2960.method_60654((String)"eldergrove:gracium_hoe1"), class_2960.method_60654((String)"eldergrove:gracium_hoe2")), player -> {
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_pickaxe", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_axe1", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_axe2", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_shovel", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_hoe1", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_hoe2", true);
        });
        Rewards.register(GRACIUM_WEAPONS, "Gracium Weapons", "This reward grants you the ability to craft the Gracium Sword and Bow, legendary weapons renowned for their unparalleled power and cuteness.", (class_1935)ModItems.GRACIUM_SWORD, 2, List.of(class_2960.method_60654((String)"eldergrove:gracium_sword"), class_2960.method_60654((String)"eldergrove:gracium_bow")), player -> {
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_sword", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_bow", true);
        });
        Rewards.register(DASH, "Dash Ability", "This reward grants you the ability to dash forward with a powerful boost, allowing you to quickly traverse the world.\n\n* Needs Gracium Armor", (class_1935)ModItems.GRACIUM_BOOTS, 3, List.of(class_2960.method_60654((String)"eldergrove:molten_gracium")), player -> {
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:molten_gracium", true);
            Utils.givePlayerItem(player, DashAction.getDashGuideBook());
        });
        Rewards.register(GRACIUM_ARMOR, "Gracium Armor", "Unlocking this reward teaches you how to craft the Gracium Helmet, Chestplate, Leggings, and Boots, powerful armor for protection.", (class_1935)ModItems.GRACIUM_CHESTPLATE, 4, List.of(class_2960.method_60654((String)"eldergrove:gracium_helmet"), class_2960.method_60654((String)"eldergrove:gracium_chestplate"), class_2960.method_60654((String)"eldergrove:gracium_leggings"), class_2960.method_60654((String)"eldergrove:gracium_boots")), player -> {
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_helmet", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_chestplate", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_leggings", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_boots", true);
        });
        Rewards.register(GRACIUM_HORSE_ARMOR, "Gracium Horse Armor", "This reward grants you the Gracium Horse Armor, offering unmatched protection and style for your trusted steed.", (class_1935)ModItems.GRACIUM_HORSE_ARMOR, 2, List.of(class_2960.method_60654((String)"eldergrove:gracium_horse_armor")), player -> Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_horse_armor", true));
        Rewards.register(GRACIUM_WOLF_ARMOR, "Gracium Wolf Armor", "This reward grants you the Gracium Wolf Armor, providing superior protection and enhancing the strength of your loyal companion.", (class_1935)ModItems.GRACIUM_WOLF_ARMOR, 2, List.of(class_2960.method_60654((String)"eldergrove:gracium_wolf_armor")), player -> Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_wolf_armor", true));
        Rewards.register(GRACIUM_HAMMER, "Gracium Hammer", "This reward grants you the Gracium Hammer recipe, allowing you to craft this tool with an extended mining area for efficient gathering.", (class_1935)ModItems.GRACIUM_HAMMER, 5, List.of(class_2960.method_60654((String)"eldergrove:gracium_hammer")), player -> Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_hammer", true));
        Rewards.register(GRACIUM_EXCAVATOR, "Gracium Excavator", "This reward unlocks the recipe for the Gracium Excavator, enabling you to craft this tool for more efficient, wide-area mining.", (class_1935)ModItems.GRACIUM_EXCAVATOR, 5, List.of(class_2960.method_60654((String)"eldergrove:gracium_excavator")), player -> Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_excavator", true));
        Rewards.register(GRACIUM_MAGNET, "Gracium Magnet", "This reward unlocks the recipe for the Gracium Magnet, a powerful tool that attracts nearby items for easy collection.", (class_1935)ModItems.GRACIUM_MAGNET, 3, List.of(class_2960.method_60654((String)"eldergrove:gracium_magnet"), class_2960.method_60654((String)"eldergrove:demagnetizer")), player -> {
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_magnet", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:demagnetizer", true);
        });
        Rewards.register(GRACIEE_ART, "Graciee Art", "This reward grants you 20 Gracie-themed painting, adding elegance and charm with its unique artistic touch to your space.", (class_1935)ModItems.GRACIEE_PAINTING, 1, List.of(class_2960.method_60654((String)"eldergrove:graciee_painting")), player -> Rewards.togglePlayerCraftingRecipe(player, "eldergrove:graciee_painting", true));
        Rewards.register(HASTE_POTION, "Strawberry Tea", "Unique brew of water and strawberries will grant you blazing mining speed. Add sugar cane for longer effect and top it off with a diamond for a powerful drink.", (class_1935)ModItems.STRAWBERRY_TEA, 3, List.of(), player -> {});
        Rewards.register(GRACIUM_BARREL, "Gracium Barrel", "This reward unlocks the recipe for Gracium Barrel, larger and more colorful storage solutions to organize your items with style and efficiency.", (class_1935)ModItems.GRACIUM_BARREL_PINK, 3, List.of(class_2960.method_60654((String)"eldergrove:gracium_barrel_white"), class_2960.method_60654((String)"eldergrove:gracium_barrel_orange"), class_2960.method_60654((String)"eldergrove:gracium_barrel_magenta"), class_2960.method_60654((String)"eldergrove:gracium_barrel_light_blue"), class_2960.method_60654((String)"eldergrove:gracium_barrel_yellow"), class_2960.method_60654((String)"eldergrove:gracium_barrel_lime"), class_2960.method_60654((String)"eldergrove:gracium_barrel_pink"), class_2960.method_60654((String)"eldergrove:gracium_barrel_gray"), class_2960.method_60654((String)"eldergrove:gracium_barrel_light_gray"), class_2960.method_60654((String)"eldergrove:gracium_barrel_cyan"), class_2960.method_60654((String)"eldergrove:gracium_barrel_purple"), class_2960.method_60654((String)"eldergrove:gracium_barrel_blue"), class_2960.method_60654((String)"eldergrove:gracium_barrel_brown"), class_2960.method_60654((String)"eldergrove:gracium_barrel_green"), class_2960.method_60654((String)"eldergrove:gracium_barrel_red"), class_2960.method_60654((String)"eldergrove:gracium_barrel_black")), player -> {
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_white", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_orange", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_magenta", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_light_blue", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_yellow", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_lime", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_pink", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_gray", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_light_gray", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_cyan", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_purple", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_blue", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_brown", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_green", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_red", true);
            Rewards.togglePlayerCraftingRecipe(player, "eldergrove:gracium_barrel_black", true);
        });
    }

    public static void register(String id, String title, String description, class_1935 item, Integer points, List<class_2960> recipes, RewardApplyFunctionInterface onEnable) {
        REWARDS.put(id, new Reward(id, title, description, item, points, recipes, onEnable));
    }

    public static Reward getReward(String id) {
        return REWARDS.get(id);
    }

    private static void togglePlayerCraftingRecipe(class_3222 player, String id, Boolean unlock) {
        class_1863 recipeManager = player.method_5682().method_3772();
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)class_2960.method_60654((String)id));
        recipeManager.method_8130(key).ifPresent(recipe -> {
            if (unlock.booleanValue()) {
                player.method_7254(Collections.singleton(recipe));
            } else {
                player.method_7333(Collections.singleton(recipe));
            }
        });
    }

    public static void unlockReward(class_3222 player, String id) {
        PlayerData playerData = WorldState.getPlayerState((class_1309)player);
        Reward reward = REWARDS.get(id);
        if (playerData.points < reward.getPoints()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"error.edlergrove.reward.not_enough_points").method_27692(class_124.field_1061), true);
            return;
        }
        playerData.rewards.add(id);
        PlayerData playerData2 = playerData;
        playerData2.points = playerData2.points - reward.getPoints();
        reward.onEnable(player);
        ModCriteria.REWARD_UNLOCK.trigger(player);
        if (playerData.rewards.size() == REWARDS.size()) {
            ModCriteria.REWARD_UNLOCK_ALL.trigger(player);
        }
        String playerName = player.method_5477().getString();
        String rewardTitle = reward.getTitle();
        class_5250 message = class_2561.method_43469((String)"screen.eldergrove.rewards.success.message", (Object[])new Object[]{playerName, rewardTitle});
        Eldergrove.LOGGER.info(playerName + " unlocked reward: " + rewardTitle);
        for (class_3222 serverPlayer : ((class_3218)player.method_37908()).method_18456()) {
            serverPlayer.method_7353((class_2561)message, false);
        }
    }

    public static boolean isRecipeLocked(class_3222 player, class_8786<?> recipe) {
        PlayerData playerData = WorldState.getPlayerState((class_1309)player);
        for (Map.Entry<String, Reward> entry : REWARDS.entrySet()) {
            String rewardId = entry.getKey();
            Reward reward = entry.getValue();
            if (playerData.rewards.contains(rewardId)) continue;
            for (class_2960 rewardRecipeId : reward.getRecipes()) {
                if (!rewardRecipeId.equals((Object)recipe.comp_1932().method_29177())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPotionIngredientLocked(class_3222 player, class_1799 stack) {
        PlayerData playerData = WorldState.getPlayerState((class_1309)player);
        if (playerData.rewards.contains(HASTE_POTION)) {
            return false;
        }
        return stack.method_31574(ModItems.STRAWBERRY) || stack.method_31574(class_1802.field_17531) || stack.method_31574(class_1802.field_8477);
    }
}

