/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.quest;

import cz.futuretek.eldergrove.quest.Tip;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Tips {
    public static final Map<String, Tip> TIPS = new HashMap<String, Tip>();
    private static final Random RANDOM = new Random();

    public static void init() {
        Tips.register("gracium_ore", "Have you ever heard of Gracium? It's a rare ore that can only be found deep in the caves, near bedrock. My grandpa once told me he found it while mining in the deepest parts of the cavern. He said it shimmered like a star in the dark. I wonder, do you think there's still some hidden down there, waiting to be discovered?");
        Tips.register("hammer_mining_area", "Listen to this story. When I was young, one of our miners ventured deeper than any before and discovered a hidden chamber swarming with monsters. He fought fiercely, defeating them one by one. Among the ruins, he found a rare spell book. When he read it, magic surged through his hammer, giving it the power to mine huge areas at once. It changed everything for him - and for Eldergrove.", "gracium_hammer");
        Tips.register("excavator_mining_area", "Here's another tale. A builder once discovered an ancient chamber deep underground, filled with monsters. He fought tirelessly until he defeated them all. In the chamber, he found a rare spell book. When he read it, magic surged through his excavator, giving it the power to clear vast areas at once, transforming his work and the village forever.", "gracium_excavator");
        Tips.register("strawberries", "When I was young, my parents told me a story about a witch who lived in an old, crooked cottage in a place where all color faded to gray. They said she lured children with the promise of sweet, ripe strawberries. Those who followed the trail into the woods were never seen again, said to have become her meals.");
        Tips.register("iron_level", "If you're looking for iron, the best place to mine is level 15. It's where the veins are richest and easiest to find. Just dig carefully and stay prepared - there's no point wasting time above or below that level. Trust me, it's the sweet spot for iron.");
        Tips.register("gold_level", "If you're looking for gold, you'll find the best veins at level -16, buried in hard deepslate. It's tough to mine, so bring a sturdy pickaxe. Be cautious, though - the deeper you go, the more dangerous it gets. Stick to level -16, and you'll uncover plenty of gold.");
        Tips.register("lapis_level", "If it's lapis lazuli you're after, level 0 is the best spot to mine. You'll find rich veins there, though they're often tucked into tough stone. Bring a good pickaxe, and watch your surroundings - mining at that depth can be risky. Stick to level 0, and you'll have the best luck.");
        Tips.register("copper_level", "If you're mining for copper, level 47 is where you'll find the most. It's close to the surface, so you won't need to struggle with tough deepslate. Just bring a sturdy pickaxe and keep an eye out - level 47 is perfect for gathering plenty of copper with ease.");
        Tips.register("coal_level", "If you're looking for coal, you'll find plenty at level 95 or higher. It's most common in elevated areas, so head toward the hills or mountains. Bring a good pickaxe and watch your step - higher locations can be tricky to navigate, but they're worth it for the abundance of coal.");
        Tips.register("diamond_redstone_level", "If you're after redstone or diamonds, you'll want to mine at level -59, deep within the darkest caves. That's where these treasures hide, buried in tough deepslate. Bring your best pickaxe and plenty of torches - it's dangerous down there, but the rewards are worth it.");
        Tips.register("biome_desert_small", "Walk south for two days along the coast, with the sound of the sea always in the background. After a while, you'll come across a small desert. It's not the vast expanse you might imagine, but a quiet stretch of sand and scattered rocks.");
        Tips.register("biome_savanna", "Take a boat and sail southwest for half a day. As you approach the savanna, you'll notice the land shifting to golden grass. The air is warm, and you might spot an armadillo rolling along the ground. The trees here are unlike any other, with their funny orange hues - perfect for a bit of humor in nature.");
        Tips.register("biome_swamp", "Sail southwest for half a day by boat, then walk nearly a full day further. As you approach, the air grows thick and damp with the scent of water. Soon, you'll find yourself surrounded by swampy waters and tall mangrove trees, their roots sprawling deep into the mud. It's a quiet, mysterious place, filled only with the occasional croak of a frog or rustling of leaves.");
        Tips.register("biome_bamboo_jungle", "When I was young, my papa took me north for two days, crossing the hills. The climb was tough, but once we descended, the air grew warmer, and the ground softer. We found ourselves in a bamboo jungle, the stalks swaying all around us. I'll never forget when we spotted a panda munching on bamboo. It was the most peaceful place I've ever been.");
        Tips.register("biome_cherry_blossom", "When I was young, every spring my papa and I would journey northwest for almost a full day. The path was long, but when we arrived, the sight of the cherry blossoms was worth it. The trees were in full bloom, their pink petals falling like soft rain. We would sit there for hours, watching the blossoms dance in the breeze.");
        Tips.register("biome_flower_forest", "One spring, I walked northeast for a full day to reach a forest bursting with flowers. The path led me through a sea of vibrant blooms, filling the air with sweet fragrances. Every step seemed to reveal a new color, and I couldn't help but marvel at the beauty. It's a place that always brings peace and the world feels a little softer.");
        Tips.register("biome_pale_garden", "Half a day's walk northeast through the dark forest brings you to a place shrouded in constant fog. The flowers there are pale, their colors drained, and the silence is thick. People speak of hearing voices in the air, though no one is ever around. It's an unsettling place - feels like it shouldn't exist, yet it calls to those who wander too close.");
        Tips.register("biome_mesa", "When I was younger, we traveled west for four days, hugging the coastline. We finally reached the vast desert, where towering mesas rose like ancient giants, casting long shadows over the endless sand. We explored the old mineshafts deep in the desert, the air heavy with the weight of forgotten stories. It felt like we were the only ones left in the world.");
        Tips.register("girl_raw_meat", "I've always hated raw meat. It just doesn't feel right to me. You see, I love animals so much that the thought of eating them - or even eating something that reminds me of them - makes me feel uneasy. I'd rather go without than hurt the creatures I care so much about.");
        Tips.register("witch_honey", "When I was young, I was told a strange story by the villagers - witches, they said, hated honey. They claimed it was because honey was pure, sweet, and natural, while witches thrived on darkness and bitterness. I never quite believed it, but there was something about the idea of witches being repelled by something so simple and good that always stuck with me.");
    }

    private static void register(String id, String text) {
        TIPS.put(id, new Tip(id, text));
    }

    private static void register(String id, String text, String depend) {
        TIPS.put(id, new Tip(id, text, depend));
    }

    public static Tip getTip(String id) {
        return TIPS.get(id);
    }

    public static String getRandomTipId(Set<String> unlockedRewards) {
        List<Map.Entry> validTips = TIPS.entrySet().stream().filter(entry -> ((Tip)entry.getValue()).getDependOnReward() == null || unlockedRewards.contains(((Tip)entry.getValue()).getDependOnReward())).toList();
        if (!validTips.isEmpty()) {
            return (String)validTips.get(RANDOM.nextInt(validTips.size())).getKey();
        }
        return (String)TIPS.keySet().stream().findAny().orElseThrow(() -> new IllegalStateException("TIPS map is empty"));
    }
}

