/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.screen;

import cz.futuretek.eldergrove.init.ModKeyBindings;
import cz.futuretek.eldergrove.network.UnlockRewardPayload;
import cz.futuretek.eldergrove.quest.Reward;
import cz.futuretek.eldergrove.quest.Rewards;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_6880;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8710;

public class RewardScreen
extends class_437 {
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"eldergrove", (String)"textures/gui/reward_screen.png");
    private static final class_2561 TITLE = class_2561.method_43471((String)"screen.eldergrove.rewards.title");
    private Set<String> unlockedRewards;
    private int points = 0;
    private Reward selectedReward;
    private class_4185 unlockButton;
    private final class_8132 layout = new class_8132((class_437)this);
    protected int x;
    protected int y;
    protected int backgroundWidth = 288;
    protected int backgroundHeight = 180;
    private final int gridX = 21;
    private final int gridY = 27;
    private final int rewardWidth = 24;
    private final int rewardHeight = 24;
    private final int spacingHorizontal = 15;
    private final int spacingVertical = 12;
    private final int rewardsPerRow = 3;

    public RewardScreen() {
        super(TITLE);
        this.unlockedRewards = Set.of();
    }

    protected void method_25426() {
        this.method_37067();
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
        this.layout.method_57726(TITLE, this.field_22793);
        this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(200).method_46431());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.unlockButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"LOL"), button -> {
            if (this.selectedReward != null) {
                ClientPlayNetworking.send((class_8710)new UnlockRewardPayload(this.selectedReward.getId()));
            }
        }).method_46434(this.x + 157, this.y + 144, 118, 20).method_46431();
        this.method_37063((class_364)this.unlockButton);
        this.setUnlockButton();
        this.layout.method_48222();
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.method_25426();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (ModKeyBindings.openRewardsScreenKey.method_1417(keyCode, scanCode)) {
            this.field_22787.method_1507(null);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void updateData(Set<String> unlockedRewards, int points) {
        this.unlockedRewards = unlockedRewards;
        this.points = points;
        if (this.selectedReward != null) {
            this.selectReward(this.selectedReward);
        }
    }

    private void selectReward(Reward reward) {
        this.selectedReward = reward;
        this.setUnlockButton();
    }

    private void setUnlockButton() {
        if (this.selectedReward == null) {
            this.unlockButton.field_22763 = false;
            this.unlockButton.field_22764 = false;
            return;
        }
        class_5250 UNLOCKED_BUTTON = class_2561.method_43471((String)"screen.eldergrove.rewards.button.unlocked");
        class_5250 UNLOCK_BUTTON = this.selectedReward.getPoints() == 1 ? class_2561.method_43469((String)"screen.eldergrove.rewards.button.unlock.one", (Object[])new Object[]{this.selectedReward.getPoints()}) : class_2561.method_43469((String)"screen.eldergrove.rewards.button.unlock.many", (Object[])new Object[]{this.selectedReward.getPoints()});
        boolean isOwned = this.unlockedRewards.contains(this.selectedReward.getId());
        this.unlockButton.method_25355((class_2561)(isOwned ? UNLOCKED_BUTTON : UNLOCK_BUTTON));
        this.unlockButton.field_22763 = this.points >= this.selectedReward.getPoints() && !isOwned;
        this.unlockButton.field_22764 = true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25290(class_1921::method_62277, BACKGROUND_TEXTURE, this.x, this.y, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, 288, 256);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_51439(this.field_22793, this.field_22785, this.x + 8, this.y + 8, 5183560, false);
        this.drawPointsAvailable(context);
        this.drawRewardsGrid(context, mouseX, mouseY);
        this.drawDetailsPanel(context, this.x + 149, this.y + 18);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void drawPointsAvailable(class_332 context) {
        class_5250 points = class_2561.method_43469((String)"screen.eldergrove.rewards.points_available", (Object[])new Object[]{this.points});
        int textWidth = this.field_22793.method_27525((class_5348)points);
        context.method_51439(this.field_22793, (class_2561)points, this.x + 281 - textWidth, this.y + 8, 5183560, false);
    }

    private void drawRewardsGrid(class_332 context, int mouseX, int mouseY) {
        AtomicInteger index = new AtomicInteger();
        Rewards.REWARDS.forEach((id, reward) -> {
            int i = this.x + 21 + index.get() % 3 * 39;
            int j = this.y + 27 + index.get() / 3 * 36;
            boolean inBounds = mouseX >= i && mouseX <= i + 24 && mouseY >= j && mouseY <= j + 24;
            this.drawRewardIcon(context, (Reward)reward, this.unlockedRewards.contains(reward.getId()), reward == this.selectedReward || inBounds, i, j);
            index.getAndIncrement();
        });
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            AtomicInteger index = new AtomicInteger(0);
            AtomicBoolean handled = new AtomicBoolean(false);
            Rewards.REWARDS.forEach((id, reward) -> {
                boolean inBounds;
                if (handled.get()) {
                    return;
                }
                int i = this.x + 21 + index.get() % 3 * 39;
                int j = this.y + 27 + index.get() / 3 * 36;
                boolean bl = inBounds = mouseX >= (double)i && mouseX <= (double)(i + 24) && mouseY >= (double)j && mouseY <= (double)(j + 24);
                if (inBounds) {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                    this.selectReward((Reward)reward);
                    handled.set(true);
                }
                index.getAndIncrement();
            });
            if (handled.get()) {
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void drawRewardIcon(class_332 context, Reward reward, boolean obtained, boolean selected, int x, int y) {
        class_2960 OBTAINED = class_2960.method_60655((String)"eldergrove", (String)"reward/obtained");
        class_2960 UNOBTAINED = class_2960.method_60655((String)"eldergrove", (String)"reward/unobtained");
        class_2960 SELECTED = class_2960.method_60655((String)"eldergrove", (String)"reward/selected");
        context.method_52706(class_1921::method_62277, obtained ? OBTAINED : UNOBTAINED, x, y, 26, 26);
        if (selected) {
            context.method_52706(class_1921::method_62277, SELECTED, x, y, 26, 26);
        }
        context.method_51445(new class_1799((class_1935)reward.getIcon().method_8389()), x + 5, y + 5);
    }

    private void drawDetailsPanel(class_332 context, int xOffset, int yOffset) {
        if (this.selectedReward != null) {
            class_2561 title = class_2561.method_30163((String)this.selectedReward.getTitle());
            context.method_51439(this.field_22793, title, xOffset + 8, yOffset + 8, 5183560, false);
            class_5489 description = class_5489.method_30890((class_327)this.field_22793, (class_2561)class_2561.method_30163((String)this.selectedReward.getDescription()), (int)118);
            description.method_30896(context, xOffset + 8, yOffset + 24, 12, 13653097);
        } else {
            context.method_51433(this.field_22793, "Select a reward", xOffset + 28, yOffset + 13, 13653097, false);
        }
    }
}

