/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.state;

import cz.futuretek.eldergrove.state.PlayerData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class WorldState
extends class_18 {
    private static final String COMPLETED_QUESTS_KEY = "completedQuests";
    private static final String PLAYERS_KEY = "players";
    private static final String PLAYER_REWARDS_KEY = "rewards";
    private static final String PLAYER_POINTS_KEY = "points";
    private static final String PLAYER_ACTIVE_QUEST_KEY = "activeQuest";
    private final Set<String> completedQuests = new HashSet<String>();
    private final HashMap<UUID, PlayerData> players = new HashMap();
    private static final class_18.class_8645<WorldState> type = new class_18.class_8645(WorldState::new, WorldState::createFromNbt, null);

    public static WorldState getData(MinecraftServer server) {
        class_26 stateManager = server.method_3847(class_1937.field_25179).method_17983();
        WorldState state = (WorldState)stateManager.method_17924(type, "eldergroveworld_state");
        state.method_80();
        return state;
    }

    public static PlayerData getPlayerState(class_1309 player) {
        WorldState serverState = WorldState.getData(player.method_37908().method_8503());
        return serverState.players.computeIfAbsent(player.method_5667(), uuid -> new PlayerData());
    }

    private class_2499 setToNbtList(Set<String> set) {
        class_2499 list = new class_2499();
        for (String item : set) {
            list.add((Object)class_2519.method_23256((String)item));
        }
        return list;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registries) {
        nbt.method_10566(COMPLETED_QUESTS_KEY, (class_2520)this.setToNbtList(this.completedQuests));
        class_2487 playersNbt = new class_2487();
        this.players.forEach((uuid, playerData) -> {
            class_2487 playerNbt = new class_2487();
            playerNbt.method_10569(PLAYER_POINTS_KEY, playerData.points.intValue());
            playerNbt.method_10582(PLAYER_ACTIVE_QUEST_KEY, Objects.requireNonNullElse(playerData.activeQuest, ""));
            playerNbt.method_10566(PLAYER_REWARDS_KEY, (class_2520)this.setToNbtList(playerData.rewards));
            playersNbt.method_10566(uuid.toString(), (class_2520)playerNbt);
        });
        nbt.method_10566(PLAYERS_KEY, (class_2520)playersNbt);
        return nbt;
    }

    public static WorldState createFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        WorldState state = new WorldState();
        state.completedQuests.addAll(tag.method_10554(COMPLETED_QUESTS_KEY, 8).stream().map(class_2520::method_10714).toList());
        class_2487 playersNbt = tag.method_10562(PLAYERS_KEY);
        playersNbt.method_10541().forEach(key -> {
            PlayerData playerData = new PlayerData();
            class_2487 playerNbtData = playersNbt.method_10562(key);
            playerData.points = playerNbtData.method_10550(PLAYER_POINTS_KEY);
            playerData.activeQuest = playerNbtData.method_10558(PLAYER_ACTIVE_QUEST_KEY).transform(s -> s.isEmpty() ? null : s);
            playerData.rewards.addAll(playerNbtData.method_10554(PLAYER_REWARDS_KEY, 8).stream().map(class_2520::method_10714).toList());
            UUID uuid = UUID.fromString(key);
            state.players.put(uuid, playerData);
        });
        return state;
    }

    public void markAsActive(String questId, class_1309 player) {
        PlayerData playerData = WorldState.getPlayerState(player);
        playerData.activeQuest = questId;
    }

    public void markAsCompleted(String questId, class_1309 player) {
        this.completedQuests.add(questId);
        PlayerData playerData = WorldState.getPlayerState(player);
        playerData.activeQuest = null;
    }

    public void markAsReset(String questId) {
        this.completedQuests.remove(questId);
        this.players.forEach((uuid, playerData) -> {
            if (questId.equals(playerData.activeQuest)) {
                playerData.activeQuest = null;
            }
        });
    }

    public Set<String> getCompletedQuests() {
        return this.completedQuests;
    }

    public Set<String> getActiveQuests() {
        HashSet<String> activeQuests = new HashSet<String>();
        this.players.forEach((uuid, playerData) -> {
            if (playerData.activeQuest != null) {
                activeQuests.add(playerData.activeQuest);
            }
        });
        return activeQuests;
    }

    public Map<UUID, String> getActiveQuestsWithUUID() {
        HashMap<UUID, String> activeQuests = new HashMap<UUID, String>();
        this.players.forEach((uuid, playerData) -> {
            if (playerData.activeQuest != null) {
                activeQuests.put((UUID)uuid, playerData.activeQuest);
            }
        });
        return activeQuests;
    }

    public boolean isQuestCompleted(String questId) {
        return this.completedQuests.contains(questId);
    }
}

