/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.utils;

import cz.futuretek.eldergrove.init.ModComponents;
import cz.futuretek.eldergrove.init.ModItems;
import cz.futuretek.eldergrove.init.ModSounds;
import cz.futuretek.eldergrove.network.DashCooldownPayload;
import cz.futuretek.eldergrove.state.PlayerData;
import cz.futuretek.eldergrove.state.WorldState;
import cz.futuretek.eldergrove.utils.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class DashAction {
    public static final int COOLDOWN_TICKS = 160;
    public static final int CHARGE_PER_ITEM = 50;
    private static final int DASH_DISTANCE = 20;
    private static final Map<UUID, Integer> COOLDOWN_MAP = new HashMap<UUID, Integer>();

    public static void doAction(class_3222 player) {
        PlayerData playerData = WorldState.getPlayerState((class_1309)player);
        if (!playerData.rewards.contains("dash")) {
            player.method_7353((class_2561)class_2561.method_43471((String)"overlayMessage.eldergrove.dash.notUnlocked").method_27692(class_124.field_1061), true);
            return;
        }
        class_1799 boots = player.method_6118(class_1304.field_6166);
        if (!boots.method_31574(ModItems.GRACIUM_BOOTS)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"overlayMessage.eldergrove.dash.notEquipped").method_27692(class_124.field_1061), true);
            return;
        }
        int charge = (Integer)boots.method_57825(ModComponents.CHARGE, (Object)0);
        if (charge <= 0) {
            player.method_7353((class_2561)class_2561.method_43471((String)"overlayMessage.eldergrove.dash.noCharge").method_27692(class_124.field_1061), true);
            return;
        }
        if (DashAction.getCooldown((class_1657)player) > 0) {
            DashAction.doCooldownSound(player);
        } else {
            DashAction.doMovement((class_1657)player);
            DashAction.doParticles(player);
            DashAction.doDashSound(player);
            DashAction.setCooldown((class_1657)player, 160);
            boots.method_57379(ModComponents.CHARGE, (Object)(charge - 1));
        }
    }

    public static int getCooldown(class_1657 player) {
        return COOLDOWN_MAP.getOrDefault(player.method_5667(), 0);
    }

    public static void setCooldown(class_1657 player, int value) {
        COOLDOWN_MAP.put(player.method_5667(), value);
    }

    public static void tick(MinecraftServer server) {
        ArrayList toRemove = new ArrayList();
        COOLDOWN_MAP.forEach((uuid, cooldown) -> {
            int newValue = cooldown - 1;
            if (newValue % 10 == 0) {
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player != null) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new DashCooldownPayload(newValue, (Integer)player.method_6118(class_1304.field_6166).method_57825(ModComponents.CHARGE, (Object)0)));
                } else {
                    toRemove.add(uuid);
                    return;
                }
            }
            if (newValue <= 0) {
                toRemove.add(uuid);
            } else {
                COOLDOWN_MAP.put((UUID)uuid, newValue);
            }
        });
        toRemove.forEach(COOLDOWN_MAP::remove);
    }

    public static class_1799 getDashGuideBook() {
        class_1799 book = new class_1799((class_1935)class_1802.field_8360);
        book.method_57379(class_9334.field_49606, (Object)new class_9302(class_9262.method_57137((Object)"Dash Guide"), "Graciee", 0, List.of(class_9262.method_57137((Object)class_2561.method_43470((String)"\u00a75\u00a7l  Dashing Trough        The Basics\u00a75\u00a70\n\n\u00a78Congratulations on unlocking the Dash reward! Now, you can harness the power of the dash in your adventures.\n\nThis guide will walk you through everything you need to know to get started.")), class_9262.method_57137((Object)class_2561.method_43470((String)"\u00a7nObtaining the Items\u00a70\n\n\u2022\u00a75 Gracium Boots\u00a70\n\u00a78These special boots are required to perform a dash and are part of another reward.\u00a70\n\n\u2022 \u00a75Molten Gracium\u00a70\n\u00a78This is the energy source that powers your dash ability.")), class_9262.method_57137((Object)class_2561.method_43470((String)"\u00a7nMolten Gracium\u00a70\n\n\u00a78Molten Gracium is crafted by combining:\u00a70\n\n\u2022 \u00a751 Gracium\u00a70\n\n\u2022 \u00a751 Lava Bucket\u00a70\n\n\u00a78Combine these items in a crafting table to produce jar of Molten Gracium.")), class_9262.method_57137((Object)class_2561.method_43470((String)"\u00a7nCharging Your Boots\u00a70\n\n\u2022 \u00a78Place your Gracium Boots and the Molten Gracium jar in an \u00a75anvil\u00a78 to charge them.\u00a70\n\n\u2022 \u00a78Each jar of Molten Gracium provides enough charge for \u00a7550 dashes\u00a78.\u00a70\n\n\u2022 \u00a78You can charge multiple jars at once.")), class_9262.method_57137((Object)class_2561.method_43470((String)"\u00a7nUsing the Dash Ability\u00a70\n\n\u2022 \u00a78Press the \u00a75X\u00a78 key to  execute a dash.\u00a70\n\n\u2022 \u00a78You can change the keybinding in the settings.\u00a70\n\n\u2022 \u00a78After each dash, there\u2019s a \u00a758 second\u00a78 cooldown.")), class_9262.method_57137((Object)class_2561.method_30163((String)"\u00a7nTips and Tricks\u00a70\n\n\u00a75Vertical Dashing:\u00a70 \u00a78Jump and dash mid-air while aiming at your target.\u00a70\n\n\u00a75Long Distance:\u00a70 \u00a78Run before dashing to cover more ground.\u00a70\n\n\u00a75Elytra Boost:\u00a70 \u00a78Use dash mid-flight for extra speed and distance."))), true));
        return book;
    }

    protected static void doMovement(class_1657 player) {
        class_243 lookVector = player.method_5720();
        float magnitude = 3.0f;
        double extraPitch = 10.0;
        class_243 dashVector = lookVector;
        float initialYaw = (float)Math.atan2(dashVector.field_1352, dashVector.field_1350);
        double dashPitch = Math.toDegrees(MathUtils.extractPitch(dashVector = MathUtils.rotateYaw(dashVector, initialYaw)));
        if (dashPitch + extraPitch > 90.0) {
            dashVector = new class_243(0.0, 1.0, 0.0);
        } else {
            dashVector = MathUtils.rotateRoll(dashVector, (float)Math.toRadians(-extraPitch));
            dashVector = MathUtils.rotateYaw(dashVector, -initialYaw);
            dashVector = dashVector.method_1029();
        }
        double coeff = 1.6 - MathUtils.map(Math.abs(dashPitch), 0.0, 90.0, 0.6, 1.0);
        dashVector = dashVector.method_1021((double)magnitude * coeff);
        player.method_18800(dashVector.field_1352, dashVector.field_1351, dashVector.field_1350);
        player.field_6037 = true;
    }

    protected static void doParticles(class_3222 player) {
        player.method_51469().method_65096((class_2394)class_2398.field_11204, player.method_23317(), player.method_23318(), player.method_23321(), 50, 1.0, 0.5, 1.0, 0.0);
    }

    protected static void doDashSound(class_3222 player) {
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.EFFECT_DASH, class_3419.field_15248, 1.0f, 1.0f);
        player.method_17356(ModSounds.EFFECT_DASH, class_3419.field_15248, 1.0f, 1.0f);
    }

    protected static void doCooldownSound(class_3222 player) {
        player.method_17356(ModSounds.EFFECT_COOLDOWN, class_3419.field_15248, 1.0f, 1.0f);
    }

    static {
        ServerTickEvents.END_SERVER_TICK.register(DashAction::tick);
    }
}

