/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.utils;

import cz.futuretek.eldergrove.entity.NpcWitchEntity;
import cz.futuretek.eldergrove.init.ModCriteria;
import cz.futuretek.eldergrove.init.ModItems;
import cz.futuretek.eldergrove.init.ModSounds;
import cz.futuretek.eldergrove.utils.EffectRunner;
import cz.futuretek.eldergrove.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class Effects {
    public static final Random random = new Random();
    public static final int STEP1_DURATION = 100;
    public static final int STEP2_DURATION = 140;
    public static final int STEP3_DURATION = 240;
    public static List<class_243> particles = new ArrayList<class_243>();

    public static void startSpell(class_3218 world, final NpcWitchEntity entity, final class_1657 target) {
        entity.method_6122(class_1268.field_5808, class_1802.field_8600.method_7854());
        entity.method_5942().method_6340();
        entity.method_5988().method_35111((class_1297)target);
        entity.method_5977(true);
        entity.setCasting(true);
        particles = Effects.generateRandomPositions(entity.method_19538(), 60, 6.0);
        final EffectRunner step3 = new EffectRunner(240, world){

            @Override
            public void onStart() {
                this.world.method_45447(null, entity.method_24515(), class_3417.field_14803, class_3419.field_15251);
                this.world.method_65096((class_2394)class_2398.field_11236, entity.method_19538().field_1352, entity.method_19538().field_1351 + 3.5, entity.method_19538().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }

            @Override
            public void onEnd() {
                entity.method_6122(class_1268.field_5808, ModItems.STRAWBERRY.method_7854());
                entity.setCasting(false);
                entity.method_5977(false);
                ModCriteria.INTERACT_NPC_WITCH_MAD.trigger((class_3222)target);
            }

            @Override
            public void onTick() {
                Effects.renderSpiral(this.world, entity.method_19538().method_1031(0.0, 3.5, 0.0), 20, 3, this.currentTick, 80);
                Effects.renderBall(this.world, entity.method_19538().method_1031(0.0, 3.5, 0.0), this.currentTick, 2, 50, 0.8f);
                if (this.currentTick % 60 == 0 && this.currentTick != 0) {
                    class_243 vector = entity.method_19538().method_1031(random.nextDouble() * 10.0 - 5.0, 0.5, random.nextDouble() * 10.0 - 5.0);
                    Effects.spawnCosmeticLightning(this.world, vector);
                    Utils.spawnAngryBees(target, 1, vector);
                }
            }
        };
        final EffectRunner step2 = new EffectRunner(140, world){

            @Override
            public void onStart() {
                entity.method_5783(ModSounds.WITCH_SPELL, 1.0f, 1.0f);
            }

            @Override
            public void onEnd() {
                particles.clear();
                step3.run();
            }

            @Override
            public void onTick() {
                Effects.moveToCentralPosition(particles, entity.method_19538().method_1031(0.0, 3.5, 0.0), this.currentTick + 1, 140);
                Effects.renderParticles(this.world, particles);
            }
        };
        EffectRunner step1 = new EffectRunner(100, world){

            @Override
            public void onStart() {
                entity.method_5783(ModSounds.WITCH_SCREAM, 1.0f, 1.0f);
            }

            @Override
            public void onEnd() {
                step2.run();
            }

            @Override
            public void onTick() {
                Effects.raiseItems(particles, 0.05);
                Effects.renderParticles(this.world, particles);
            }
        };
        step1.run();
    }

    private static void renderParticles(class_3218 world, List<class_243> positions) {
        for (class_243 pos : positions) {
            world.method_65096((class_2394)class_2398.field_11219, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static List<class_243> generateRandomPositions(class_243 centralPosition, int count, double maxRadius) {
        ArrayList<class_243> positions = new ArrayList<class_243>();
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double radius = random.nextDouble() * maxRadius;
            double x = centralPosition.field_1352 + radius * Math.cos(angle);
            double z = centralPosition.field_1350 + radius * Math.sin(angle);
            double y = centralPosition.field_1351 - (0.5 + random.nextDouble() * 1.5);
            positions.add(new class_243(x, y, z));
        }
        return positions;
    }

    public static void raiseItems(List<class_243> positions, double rate) {
        for (int i = 0; i < positions.size(); ++i) {
            class_243 pos = positions.get(i);
            double targetY = pos.field_1351 + rate;
            positions.set(i, new class_243(pos.field_1352, targetY, pos.field_1350));
        }
    }

    public static void moveToCentralPosition(List<class_243> positions, class_243 centralPosition, int step, int totalSteps) {
        double progress = (double)step / (double)totalSteps;
        for (int i = 0; i < positions.size(); ++i) {
            class_243 pos = positions.get(i);
            double dx = centralPosition.field_1352 - pos.field_1352;
            double dy = centralPosition.field_1351 - pos.field_1351;
            double dz = centralPosition.field_1350 - pos.field_1350;
            int remainingSteps = totalSteps - step;
            double velocityX = dx / (double)remainingSteps;
            double velocityY = dy / (double)remainingSteps;
            double velocityZ = dz / (double)remainingSteps;
            double accelerationFactor = Math.pow(progress, 2.0);
            positions.set(i, pos.method_1031(velocityX *= accelerationFactor, velocityY *= accelerationFactor, velocityZ *= accelerationFactor));
        }
    }

    public static void renderBall(class_3218 world, class_243 origin, int step, int countPerTick, int totalCount, float size) {
        int innerStep = step;
        for (int i = 0; i < countPerTick; ++i) {
            float t = (float)(Math.PI / (double)totalCount * (double)(++innerStep));
            float r = (float)(Math.sin(t) * (double)size);
            float s1 = (float)(Math.PI * 2 * (double)t);
            float s2 = -s1;
            class_243 vector = origin.method_1031((double)(size * r) * Math.cos(s1), (double)(size * size) * Math.cos(t), (double)(size * r) * Math.sin(s1));
            world.method_65096((class_2394)class_2398.field_22246, vector.field_1352, vector.field_1351, vector.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            class_243 vector2 = origin.method_1031((double)(size * r) * Math.cos(s2), (double)(size * size) * Math.cos(t), (double)(size * r) * Math.sin(s2));
            world.method_65096((class_2394)class_2398.field_22246, vector2.field_1352, vector2.field_1351, vector2.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void renderSpiral(class_3218 world, class_243 center, int particleCount, int arms, int step, int totalSteps) {
        double elapsedTime = (double)step / (double)totalSteps * Math.PI * 2.0;
        for (int i = 0; i < particleCount; ++i) {
            int arm = i % arms;
            double armOffset = Math.PI * 2 / (double)arms * (double)arm;
            double progress = (double)i / (double)particleCount;
            double theta = progress * 4.0 * Math.PI + armOffset;
            double radius = 0.5 + progress * 6.0;
            double rotatedTheta = theta + elapsedTime;
            double x = radius * Math.cos(rotatedTheta);
            double z = radius * Math.sin(rotatedTheta);
            double y = center.field_1351 + Math.sin(progress * Math.PI * 2.0) * 0.5;
            world.method_65096((class_2394)class_2398.field_22246, center.field_1352 + x, y, center.field_1350 + z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnCosmeticLightning(class_3218 world, class_243 pos) {
        class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
        lightning.method_33574(pos);
        lightning.method_29498(true);
        world.method_8649((class_1297)lightning);
    }
}

