/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.utils;

import cz.futuretek.eldergrove.item.MagnetItem;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class MagnetUtils {
    public static int EMPTY_SLOT = -1;

    private static MagnetActionResult toggleMagnetInternal(class_3222 player) {
        if (MagnetUtils.getActiveMagnetSlot(player) != EMPTY_SLOT) {
            MagnetUtils.deactivateAllMagnets((class_1657)player);
            return MagnetActionResult.INACTIVE;
        }
        int slot = MagnetUtils.activateFirstNonBrokenMagnet((class_1657)player);
        return slot != EMPTY_SLOT ? MagnetActionResult.ACTIVE : MagnetActionResult.NOT_FOUND;
    }

    public static void toggleMagnet(class_3222 player) {
        MagnetActionResult result = MagnetUtils.toggleMagnetInternal(player);
        class_5250 message = switch (result.ordinal()) {
            case 0 -> class_2561.method_43469((String)"overlayMessage.eldergrove.magnet.status", (Object[])new Object[]{class_2561.method_43471((String)"itemTooltip.eldergrove.magnet_item.active").method_27692(class_124.field_1060)});
            case 1 -> class_2561.method_43469((String)"overlayMessage.eldergrove.magnet.status", (Object[])new Object[]{class_2561.method_43471((String)"itemTooltip.eldergrove.magnet_item.inactive").method_27692(class_124.field_1061)});
            default -> class_2561.method_43471((String)"overlayMessage.eldergrove.magnet.notFound");
        };
        player.method_7353((class_2561)message, true);
    }

    public static int getActiveMagnetSlot(class_3222 player) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (!(stack.method_7909() instanceof MagnetItem) || MagnetItem.isBroken(stack) || !MagnetItem.isActive(stack)) continue;
            return i;
        }
        return EMPTY_SLOT;
    }

    public static void deactivateAllMagnets(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (!(stack.method_7909() instanceof MagnetItem) || !MagnetItem.isActive(stack)) continue;
            MagnetItem.setIsActive(stack, false);
        }
    }

    public static int activateFirstNonBrokenMagnet(class_1657 player) {
        int activatedSlot = EMPTY_SLOT;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (!(stack.method_7909() instanceof MagnetItem) || MagnetItem.isBroken(stack)) continue;
            MagnetItem.setIsActive(stack, activatedSlot == EMPTY_SLOT);
            if (activatedSlot != EMPTY_SLOT) continue;
            activatedSlot = i;
        }
        if (activatedSlot != EMPTY_SLOT) {
            return activatedSlot;
        }
        return EMPTY_SLOT;
    }

    public static void decreaseDurability(int slot, class_1657 player, int amount) {
        int damageTaken;
        class_3222 serverPlayer = (class_3222)player;
        class_1799 stack = player.method_31548().method_5438(slot);
        if (player.method_56992()) {
            return;
        }
        int n = damageTaken = amount > 0 ? class_1890.method_60117((class_3218)((class_3218)player.method_37908()), (class_1799)stack, (int)amount) : amount;
        if (damageTaken != 0) {
            int newStackDamage = stack.method_7919() + damageTaken;
            class_174.field_1185.method_8960(serverPlayer, stack, newStackDamage);
            stack.method_7974(newStackDamage);
            if (newStackDamage > stack.method_7936()) {
                serverPlayer.method_17356(class_3417.field_15075, class_3419.field_15254, 1.0f, 1.0f);
                MagnetItem.setIsActive(stack, false);
                MagnetUtils.activateFirstNonBrokenMagnet(player);
            }
        }
    }

    public static enum MagnetActionResult {
        ACTIVE,
        INACTIVE,
        NOT_FOUND;

    }
}

