/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.utils;

import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class Scheduler {
    private static final PriorityQueue<ScheduledTask> TASK_QUEUE = new PriorityQueue();
    private static final AtomicLong TASK_ID_GENERATOR = new AtomicLong();

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> Scheduler.processTasks());
    }

    public static long schedule(int delayTicks, Runnable task) {
        long id = TASK_ID_GENERATOR.incrementAndGet();
        TASK_QUEUE.add(new ScheduledTask(id, delayTicks, task));
        return id;
    }

    public static boolean cancel(long taskId) {
        return TASK_QUEUE.removeIf(task -> task.getId() == taskId);
    }

    private static void processTasks() {
        if (TASK_QUEUE.isEmpty()) {
            return;
        }
        long currentTick = System.currentTimeMillis();
        while (!TASK_QUEUE.isEmpty() && TASK_QUEUE.peek().getExecutionTime() <= currentTick) {
            ScheduledTask task = TASK_QUEUE.poll();
            if (task == null) continue;
            task.getTask().run();
        }
    }

    public static class ScheduledTask
    implements Comparable<ScheduledTask> {
        private final long id;
        private final long executionTime;
        private final Runnable task;

        public ScheduledTask(long id, int delayTicks, Runnable task) {
            this.id = id;
            this.executionTime = System.currentTimeMillis() + (long)delayTicks * 50L;
            this.task = task;
        }

        public long getId() {
            return this.id;
        }

        public long getExecutionTime() {
            return this.executionTime;
        }

        public Runnable getTask() {
            return this.task;
        }

        @Override
        public int compareTo(ScheduledTask other) {
            return Long.compare(this.executionTime, other.executionTime);
        }
    }
}

