/*
 * Decompiled with CFR 0.152.
 */
package cz.futuretek.eldergrove.utils;

import cz.futuretek.eldergrove.Eldergrove;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3675;
import net.minecraft.class_4466;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class Utils {
    public static void givePlayerItem(class_3222 player, class_1799 itemStack) {
        if (!player.method_31548().method_7394(itemStack)) {
            player.method_7328(itemStack, false);
        }
    }

    public static void throwItemAtPlayer(class_3218 world, class_2338 entityPos, class_1657 target, class_1799 itemStack) {
        class_243 spawnPosition = new class_243((double)entityPos.method_10263() + 0.5, (double)entityPos.method_10264() + 1.5, (double)entityPos.method_10260() + 0.5);
        class_1542 thrownItem = new class_1542((class_1937)world, spawnPosition.field_1352, spawnPosition.field_1351, spawnPosition.field_1350, itemStack);
        class_243 targetPosition = target.method_19538().method_1031(0.0, 1.5, 0.0);
        class_243 velocity = targetPosition.method_1020(spawnPosition).method_1029().method_1021(0.2);
        thrownItem.method_18799(velocity);
        world.method_8649((class_1297)thrownItem);
    }

    public static class_1309 checkEntityIsAlive(class_3218 world, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        class_1309 entity = (class_1309)world.method_14190(uuid);
        if (entity != null && entity.method_5805()) {
            return entity;
        }
        return null;
    }

    public static void removeEntity(class_1937 world, UUID uuid, class_2338 pos) {
        class_3218 serverWorld;
        class_1297 entity;
        if (uuid != null && world instanceof class_3218 && (entity = (serverWorld = (class_3218)world).method_14190(uuid)) != null) {
            Eldergrove.LOGGER.info("Removing entity tied to block " + String.valueOf(pos));
            entity.method_31472();
        }
    }

    public static void spawnEntityAroundBlock(class_1309 entity, class_3218 serverWorld, class_2338 blockPos, int radius) {
        class_5819 random = serverWorld.field_9229;
        Optional<class_2338> spawnPos = Utils.findValidSpawnPosition(entity, (class_5425)serverWorld, blockPos, radius, random);
        if (spawnPos.isPresent()) {
            class_2338 validPos = spawnPos.get();
            entity.method_23327((double)validPos.method_10263() + 0.5, (double)validPos.method_10264(), (double)validPos.method_10260() + 0.5);
            serverWorld.method_8649((class_1297)entity);
            Eldergrove.LOGGER.info("Spawned entity at: " + String.valueOf(validPos));
        } else {
            Eldergrove.LOGGER.warn("No valid position found to spawn entity around block: " + String.valueOf(blockPos));
        }
    }

    private static Optional<class_2338> findValidSpawnPosition(class_1309 entity, class_5425 world, class_2338 blockPos, int radius, class_5819 random) {
        for (int attempt = 0; attempt < 20; ++attempt) {
            int offsetZ;
            int offsetX = random.method_43048(radius * 2 + 1) - radius;
            class_2338 potentialPos = blockPos.method_10069(offsetX, 0, offsetZ = random.method_43048(radius * 2 + 1) - radius);
            if (!Utils.canSpawnEntityAt(entity, world, potentialPos)) continue;
            return Optional.of(potentialPos);
        }
        return Optional.empty();
    }

    private static boolean canSpawnEntityAt(class_1309 entity, class_5425 world, class_2338 pos) {
        boolean hasSolidGround = world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074());
        entity.method_23327((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.01, (double)pos.method_10260() + 0.5);
        boolean hasSpace = world.method_8320(pos).method_26215() && world.method_8320(pos.method_10084()).method_26215();
        return hasSolidGround && hasSpace;
    }

    public static void spawnAngryBees(class_1657 target, int count, class_243 pos) {
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < count; ++i) {
                class_4466 bee = new class_4466(class_1299.field_20346, (class_1937)serverWorld);
                bee.method_33574(pos.method_1031(-1.0 + 2.0 * Math.random(), 2.0 + Math.random() * 2.0, -1.0 + 2.0 * Math.random()));
                Objects.requireNonNull(bee.method_5996(class_5134.field_23720)).method_6192(1.0);
                bee.method_29514(1200);
                bee.method_5980((class_1309)target);
                serverWorld.method_8649((class_1297)bee);
            }
        }
    }

    public static boolean areaToolOffsetKeyModifierPressed(class_310 client) {
        long windowHandle = client.method_22683().method_4490();
        return class_3675.method_15987((long)windowHandle, (int)340) && class_3675.method_15987((long)windowHandle, (int)341);
    }
}

